/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.IEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.Group;
import com.dianping.cat.home.router.entity.GroupServer;
import com.dianping.cat.home.router.entity.Network;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.entity.ServerGroup;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private RouterConfig m_routerConfig;

    public DefaultMerger() {
    }

    public DefaultMerger(RouterConfig routerConfig) {
        this.m_routerConfig = routerConfig;
        this.m_objs.push(routerConfig);
    }

    public RouterConfig getRouterConfig() {
        return this.m_routerConfig;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeDefaultServer(DefaultServer to, DefaultServer from) {
        to.mergeAttributes(from);
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeGroup(Group to, Group from) {
        to.mergeAttributes(from);
    }

    protected void mergeGroupServer(GroupServer to, GroupServer from) {
        to.mergeAttributes(from);
    }

    protected void mergeNetwork(Network to, Network from) {
        to.mergeAttributes(from);
    }

    protected void mergeNetworkPolicy(NetworkPolicy to, NetworkPolicy from) {
        to.mergeAttributes(from);
    }

    protected void mergeRouterConfig(RouterConfig to, RouterConfig from) {
        to.mergeAttributes(from);
    }

    protected void mergeServer(Server to, Server from) {
        to.mergeAttributes(from);
    }

    protected void mergeServerGroup(ServerGroup to, ServerGroup from) {
        to.mergeAttributes(from);
    }

    public void visitDefaultServer(DefaultServer from) {
        DefaultServer to = (DefaultServer)this.m_objs.peek();
        this.mergeDefaultServer(to, from);
        this.visitDefaultServerChildren(to, from);
    }

    protected void visitDefaultServerChildren(DefaultServer to, DefaultServer from) {
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
        for (Group source : from.getGroups().values()) {
            Group target = to.findGroup(source.getId());
            if (target == null) {
                target = new Group(source.getId());
                to.addGroup(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitGroup(Group from) {
        Group to = (Group)this.m_objs.peek();
        this.mergeGroup(to, from);
        this.visitGroupChildren(to, from);
    }

    protected void visitGroupChildren(Group to, Group from) {
        for (Server source : from.getServers()) {
            Server target = null;
            if (target == null) {
                target = new Server();
                to.addServer(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitGroupServer(GroupServer from) {
        GroupServer to = (GroupServer)this.m_objs.peek();
        this.mergeGroupServer(to, from);
        this.visitGroupServerChildren(to, from);
    }

    protected void visitGroupServerChildren(GroupServer to, GroupServer from) {
    }

    public void visitNetwork(Network from) {
        Network to = (Network)this.m_objs.peek();
        this.mergeNetwork(to, from);
        this.visitNetworkChildren(to, from);
    }

    protected void visitNetworkChildren(Network to, Network from) {
    }

    public void visitNetworkPolicy(NetworkPolicy from) {
        NetworkPolicy to = (NetworkPolicy)this.m_objs.peek();
        this.mergeNetworkPolicy(to, from);
        this.visitNetworkPolicyChildren(to, from);
    }

    protected void visitNetworkPolicyChildren(NetworkPolicy to, NetworkPolicy from) {
        for (Network source : from.getNetworks().values()) {
            Network target = to.findNetwork(source.getId());
            if (target == null) {
                target = new Network(source.getId());
                to.addNetwork(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitRouterConfig(RouterConfig from) {
        RouterConfig to = (RouterConfig)this.m_objs.peek();
        this.mergeRouterConfig(to, from);
        this.visitRouterConfigChildren(to, from);
    }

    protected void visitRouterConfigChildren(RouterConfig to, RouterConfig from) {
        DefaultServer target;
        for (DefaultServer source : from.getDefaultServers().values()) {
            target = to.findDefaultServer(source.getId());
            if (target == null) {
                target = new DefaultServer(source.getId());
                to.addDefaultServer(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (DefaultServer source : from.getNetworkPolicies().values()) {
            target = to.findNetworkPolicy(source.getId());
            if (target == null) {
                target = new NetworkPolicy(source.getId());
                to.addNetworkPolicy((NetworkPolicy)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (DefaultServer source : from.getServerGroups().values()) {
            target = to.findServerGroup(source.getId());
            if (target == null) {
                target = new ServerGroup(source.getId());
                to.addServerGroup((ServerGroup)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (DefaultServer source : from.getDomains().values()) {
            target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain((Domain)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitServer(Server from) {
        Server to = (Server)this.m_objs.peek();
        this.mergeServer(to, from);
        this.visitServerChildren(to, from);
    }

    protected void visitServerChildren(Server to, Server from) {
    }

    public void visitServerGroup(ServerGroup from) {
        ServerGroup to = (ServerGroup)this.m_objs.peek();
        this.mergeServerGroup(to, from);
        this.visitServerGroupChildren(to, from);
    }

    protected void visitServerGroupChildren(ServerGroup to, ServerGroup from) {
        for (GroupServer source : from.getGroupServers().values()) {
            GroupServer target = to.findGroupServer(source.getId());
            if (target == null) {
                target = new GroupServer(source.getId());
                to.addGroupServer(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }
}

