/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.transform;

import com.dianping.cat.home.router.IEntity;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.Group;
import com.dianping.cat.home.router.entity.GroupServer;
import com.dianping.cat.home.router.entity.Network;
import com.dianping.cat.home.router.entity.NetworkPolicy;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.entity.ServerGroup;
import com.dianping.cat.home.router.transform.DefaultLinker;
import com.dianping.cat.home.router.transform.DefaultSaxMaker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static RouterConfig parse(InputStream in) throws SAXException, IOException {
        return (RouterConfig)DefaultSaxParser.parseEntity(RouterConfig.class, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static RouterConfig parse(Reader reader) throws SAXException, IOException {
        return (RouterConfig)DefaultSaxParser.parseEntity(RouterConfig.class, (InputSource)new InputSource((Reader)DefaultSaxParser.removeBOM((Object)reader)));
    }

    public static RouterConfig parse(String xml) throws SAXException, IOException {
        return (RouterConfig)DefaultSaxParser.parseEntity(RouterConfig.class, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != 0 && str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForDefaultServer(DefaultServer parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForDomain(Domain parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"group".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under domain!", qName));
        }
        Group group = this.m_maker.buildGroup(attributes);
        this.m_linker.onGroup(parentObj, group);
        this.m_objs.push(group);
        this.m_tags.push(qName);
    }

    private void parseForGroup(Group parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"server".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under group!", qName));
        }
        Server server = this.m_maker.buildServer(attributes);
        this.m_linker.onServer(parentObj, server);
        this.m_objs.push(server);
        this.m_tags.push(qName);
    }

    private void parseForGroupServer(GroupServer parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForNetwork(Network parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForNetworkPolicy(NetworkPolicy parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"network".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under network-policy!", qName));
        }
        Network network = this.m_maker.buildNetwork(attributes);
        this.m_linker.onNetwork(parentObj, network);
        this.m_objs.push(network);
        this.m_tags.push(qName);
    }

    private void parseForRouterConfig(RouterConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("default-server".equals(qName)) {
            DefaultServer defaultServer = this.m_maker.buildDefaultServer(attributes);
            this.m_linker.onDefaultServer(parentObj, defaultServer);
            this.m_objs.push(defaultServer);
        } else if ("network-policy".equals(qName)) {
            NetworkPolicy networkPolicy = this.m_maker.buildNetworkPolicy(attributes);
            this.m_linker.onNetworkPolicy(parentObj, networkPolicy);
            this.m_objs.push(networkPolicy);
        } else if ("server-group".equals(qName)) {
            ServerGroup serverGroup = this.m_maker.buildServerGroup(attributes);
            this.m_linker.onServerGroup(parentObj, serverGroup);
            this.m_objs.push(serverGroup);
        } else if ("domain".equals(qName)) {
            Domain domain = this.m_maker.buildDomain(attributes);
            this.m_linker.onDomain(parentObj, domain);
            this.m_objs.push(domain);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under router-config!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForServer(Server parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForServerGroup(ServerGroup parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"group-server".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under server-group!", qName));
        }
        GroupServer groupServer = this.m_maker.buildGroupServer(attributes);
        this.m_linker.onGroupServer(parentObj, groupServer);
        this.m_objs.push(groupServer);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("router-config".equals(qName)) {
            RouterConfig routerConfig = this.m_maker.buildRouterConfig(attributes);
            this.m_entity = routerConfig;
            this.m_objs.push(routerConfig);
            this.m_tags.push(qName);
        } else if ("default-server".equals(qName)) {
            DefaultServer defaultServer = this.m_maker.buildDefaultServer(attributes);
            this.m_entity = defaultServer;
            this.m_objs.push(defaultServer);
            this.m_tags.push(qName);
        } else if ("network-policy".equals(qName)) {
            NetworkPolicy networkPolicy = this.m_maker.buildNetworkPolicy(attributes);
            this.m_entity = networkPolicy;
            this.m_objs.push(networkPolicy);
            this.m_tags.push(qName);
        } else if ("network".equals(qName)) {
            Network network = this.m_maker.buildNetwork(attributes);
            this.m_entity = network;
            this.m_objs.push(network);
            this.m_tags.push(qName);
        } else if ("server-group".equals(qName)) {
            ServerGroup serverGroup = this.m_maker.buildServerGroup(attributes);
            this.m_entity = serverGroup;
            this.m_objs.push(serverGroup);
            this.m_tags.push(qName);
        } else if ("group-server".equals(qName)) {
            GroupServer groupServer = this.m_maker.buildGroupServer(attributes);
            this.m_entity = groupServer;
            this.m_objs.push(groupServer);
            this.m_tags.push(qName);
        } else if ("domain".equals(qName)) {
            Domain domain = this.m_maker.buildDomain(attributes);
            this.m_entity = domain;
            this.m_objs.push(domain);
            this.m_tags.push(qName);
        } else if ("group".equals(qName)) {
            Group group = this.m_maker.buildGroup(attributes);
            this.m_entity = group;
            this.m_objs.push(group);
            this.m_tags.push(qName);
        } else if ("server".equals(qName)) {
            Server server = this.m_maker.buildServer(attributes);
            this.m_entity = server;
            this.m_objs.push(server);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof RouterConfig) {
                this.parseForRouterConfig((RouterConfig)parent, tag, qName, attributes);
            } else if (parent instanceof DefaultServer) {
                this.parseForDefaultServer((DefaultServer)parent, tag, qName, attributes);
            } else if (parent instanceof NetworkPolicy) {
                this.parseForNetworkPolicy((NetworkPolicy)parent, tag, qName, attributes);
            } else if (parent instanceof Network) {
                this.parseForNetwork((Network)parent, tag, qName, attributes);
            } else if (parent instanceof ServerGroup) {
                this.parseForServerGroup((ServerGroup)parent, tag, qName, attributes);
            } else if (parent instanceof GroupServer) {
                this.parseForGroupServer((GroupServer)parent, tag, qName, attributes);
            } else if (parent instanceof Domain) {
                this.parseForDomain((Domain)parent, tag, qName, attributes);
            } else if (parent instanceof Group) {
                this.parseForGroup((Group)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Server)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForServer((Server)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }

    protected Date toDate(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

