/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.server.entity;

import com.dianping.cat.home.server.BaseEntity;
import com.dianping.cat.home.server.IVisitor;
import com.dianping.cat.home.server.entity.Item;
import java.util.LinkedHashMap;
import java.util.Map;

public class Group
extends BaseEntity<Group> {
    private String m_id;
    private Map<String, Item> m_items = new LinkedHashMap();

    public Group() {
    }

    public Group(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitGroup(this);
    }

    public Group addItem(Item item) {
        this.m_items.put(item.getId(), item);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            Group _o = (Group)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Item findItem(String id) {
        return (Item)this.m_items.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item findOrCreateItem(String id) {
        Item item = (Item)this.m_items.get(id);
        if (item == null) {
            Map map = this.m_items;
            synchronized (map) {
                item = (Item)this.m_items.get(id);
                if (item == null) {
                    item = new Item(id);
                    this.m_items.put(id, item);
                }
            }
        }
        return item;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Item> getItems() {
        return this.m_items;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Group other) {
        this.assertAttributeEquals((Object)other, "group", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Item removeItem(String id) {
        return (Item)this.m_items.remove(id);
    }

    public Group setId(String id) {
        this.m_id = id;
        return this;
    }
}

