/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.server.entity;

import com.dianping.cat.home.server.BaseEntity;
import com.dianping.cat.home.server.IVisitor;
import com.dianping.cat.home.server.entity.Segment;
import java.util.LinkedHashMap;
import java.util.Map;

public class Item
extends BaseEntity<Item> {
    private String m_id;
    private Map<String, Segment> m_segments = new LinkedHashMap();

    public Item() {
    }

    public Item(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitItem(this);
    }

    public Item addSegment(Segment segment) {
        this.m_segments.put(segment.getId(), segment);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Item) {
            Item _o = (Item)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Segment findSegment(String id) {
        return (Segment)this.m_segments.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment findOrCreateSegment(String id) {
        Segment segment = (Segment)this.m_segments.get(id);
        if (segment == null) {
            Map map = this.m_segments;
            synchronized (map) {
                segment = (Segment)this.m_segments.get(id);
                if (segment == null) {
                    segment = new Segment(id);
                    this.m_segments.put(id, segment);
                }
            }
        }
        return segment;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Segment> getSegments() {
        return this.m_segments;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Item other) {
        this.assertAttributeEquals((Object)other, "item", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Segment removeSegment(String id) {
        return (Segment)this.m_segments.remove(id);
    }

    public Item setId(String id) {
        this.m_id = id;
        return this;
    }
}

