/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.client.entity;

import com.dianping.cat.home.service.client.BaseEntity;
import com.dianping.cat.home.service.client.IVisitor;
import com.dianping.cat.home.service.client.entity.Domain;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClientReport
extends BaseEntity<ClientReport> {
    private String m_domain;
    private Date m_startTime;
    private Date m_endTime;
    private Map<String, Domain> m_domains = new LinkedHashMap();

    public ClientReport() {
    }

    public ClientReport(String domain) {
        this.m_domain = domain;
    }

    public void accept(IVisitor visitor) {
        visitor.visitClientReport(this);
    }

    public ClientReport addDomain(Domain domain) {
        this.m_domains.put(domain.getId(), domain);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientReport) {
            ClientReport _o = (ClientReport)obj;
            return this.equals((Object)this.getDomain(), (Object)_o.getDomain());
        }
        return false;
    }

    public Domain findDomain(String id) {
        return (Domain)this.m_domains.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain findOrCreateDomain(String id) {
        Domain domain = (Domain)this.m_domains.get(id);
        if (domain == null) {
            Map map = this.m_domains;
            synchronized (map) {
                domain = (Domain)this.m_domains.get(id);
                if (domain == null) {
                    domain = new Domain(id);
                    this.m_domains.put(id, domain);
                }
            }
        }
        return domain;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public Date getEndTime() {
        return this.m_endTime;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_domain == null ? 0 : this.m_domain.hashCode());
        return hash;
    }

    public void mergeAttributes(ClientReport other) {
        this.assertAttributeEquals((Object)other, "client-report", "domain", (Object)this.m_domain, (Object)other.getDomain());
        if (other.getStartTime() != null) {
            this.m_startTime = other.getStartTime();
        }
        if (other.getEndTime() != null) {
            this.m_endTime = other.getEndTime();
        }
    }

    public Domain removeDomain(String id) {
        return (Domain)this.m_domains.remove(id);
    }

    public ClientReport setDomain(String domain) {
        this.m_domain = domain;
        return this;
    }

    public ClientReport setEndTime(Date endTime) {
        this.m_endTime = endTime;
        return this;
    }

    public ClientReport setStartTime(Date startTime) {
        this.m_startTime = startTime;
        return this;
    }
}

