/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.client.entity;

import com.dianping.cat.home.service.client.BaseEntity;
import com.dianping.cat.home.service.client.IVisitor;
import com.dianping.cat.home.service.client.entity.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class Domain
extends BaseEntity<Domain> {
    private String m_id;
    private long m_totalCount;
    private long m_failureCount;
    private double m_failurePercent;
    private double m_sum;
    private double m_avg;
    private Map<String, Method> m_methods = new LinkedHashMap();

    public Domain() {
    }

    public Domain(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    public Domain addMethod(Method method) {
        this.m_methods.put(method.getId(), method);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Domain) {
            Domain _o = (Domain)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Method findMethod(String id) {
        return (Method)this.m_methods.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method findOrCreateMethod(String id) {
        Method method = (Method)this.m_methods.get(id);
        if (method == null) {
            Map map = this.m_methods;
            synchronized (map) {
                method = (Method)this.m_methods.get(id);
                if (method == null) {
                    method = new Method(id);
                    this.m_methods.put(id, method);
                }
            }
        }
        return method;
    }

    public double getAvg() {
        return this.m_avg;
    }

    public long getFailureCount() {
        return this.m_failureCount;
    }

    public double getFailurePercent() {
        return this.m_failurePercent;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Method> getMethods() {
        return this.m_methods;
    }

    public double getSum() {
        return this.m_sum;
    }

    public long getTotalCount() {
        return this.m_totalCount;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public Domain incFailureCount() {
        ++this.m_failureCount;
        return this;
    }

    public Domain incFailureCount(long failureCount) {
        this.m_failureCount += failureCount;
        return this;
    }

    public Domain incSum() {
        this.m_sum += 1.0;
        return this;
    }

    public Domain incSum(double sum) {
        this.m_sum += sum;
        return this;
    }

    public Domain incTotalCount() {
        ++this.m_totalCount;
        return this;
    }

    public Domain incTotalCount(long totalCount) {
        this.m_totalCount += totalCount;
        return this;
    }

    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals((Object)other, "domain", "id", (Object)this.m_id, (Object)other.getId());
        this.m_totalCount = other.getTotalCount();
        this.m_failureCount = other.getFailureCount();
        this.m_failurePercent = other.getFailurePercent();
        this.m_sum = other.getSum();
        this.m_avg = other.getAvg();
    }

    public Method removeMethod(String id) {
        return (Method)this.m_methods.remove(id);
    }

    public Domain setAvg(double avg) {
        this.m_avg = avg;
        return this;
    }

    public Domain setFailureCount(long failureCount) {
        this.m_failureCount = failureCount;
        return this;
    }

    public Domain setFailurePercent(double failurePercent) {
        this.m_failurePercent = failurePercent;
        return this;
    }

    public Domain setId(String id) {
        this.m_id = id;
        return this;
    }

    public Domain setSum(double sum) {
        this.m_sum = sum;
        return this;
    }

    public Domain setTotalCount(long totalCount) {
        this.m_totalCount = totalCount;
        return this;
    }
}

