/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.client.entity;

import com.dianping.cat.home.service.client.BaseEntity;
import com.dianping.cat.home.service.client.IVisitor;

public class Method
extends BaseEntity<Method> {
    private String m_id;
    private String m_service;
    private long m_totalCount;
    private long m_failureCount;
    private double m_failurePercent;
    private double m_sum;
    private double m_avg;
    private double m_qps;
    private double m_timeout;

    public Method() {
    }

    public Method(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitMethod(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Method) {
            Method _o = (Method)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public double getAvg() {
        return this.m_avg;
    }

    public long getFailureCount() {
        return this.m_failureCount;
    }

    public double getFailurePercent() {
        return this.m_failurePercent;
    }

    public String getId() {
        return this.m_id;
    }

    public double getQps() {
        return this.m_qps;
    }

    public String getService() {
        return this.m_service;
    }

    public double getSum() {
        return this.m_sum;
    }

    public double getTimeout() {
        return this.m_timeout;
    }

    public long getTotalCount() {
        return this.m_totalCount;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public Method incFailureCount() {
        ++this.m_failureCount;
        return this;
    }

    public Method incFailureCount(long failureCount) {
        this.m_failureCount += failureCount;
        return this;
    }

    public Method incSum() {
        this.m_sum += 1.0;
        return this;
    }

    public Method incSum(double sum) {
        this.m_sum += sum;
        return this;
    }

    public Method incTotalCount() {
        ++this.m_totalCount;
        return this;
    }

    public Method incTotalCount(long totalCount) {
        this.m_totalCount += totalCount;
        return this;
    }

    public void mergeAttributes(Method other) {
        this.assertAttributeEquals((Object)other, "method", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getService() != null) {
            this.m_service = other.getService();
        }
        this.m_totalCount = other.getTotalCount();
        this.m_failureCount = other.getFailureCount();
        this.m_failurePercent = other.getFailurePercent();
        this.m_sum = other.getSum();
        this.m_avg = other.getAvg();
        this.m_qps = other.getQps();
        this.m_timeout = other.getTimeout();
    }

    public Method setAvg(double avg) {
        this.m_avg = avg;
        return this;
    }

    public Method setFailureCount(long failureCount) {
        this.m_failureCount = failureCount;
        return this;
    }

    public Method setFailurePercent(double failurePercent) {
        this.m_failurePercent = failurePercent;
        return this;
    }

    public Method setId(String id) {
        this.m_id = id;
        return this;
    }

    public Method setQps(double qps) {
        this.m_qps = qps;
        return this;
    }

    public Method setService(String service) {
        this.m_service = service;
        return this;
    }

    public Method setSum(double sum) {
        this.m_sum = sum;
        return this;
    }

    public Method setTimeout(double timeout) {
        this.m_timeout = timeout;
        return this;
    }

    public Method setTotalCount(long totalCount) {
        this.m_totalCount = totalCount;
        return this;
    }
}

