/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.client.transform;

import com.dianping.cat.home.service.client.IEntity;
import com.dianping.cat.home.service.client.entity.ClientReport;
import com.dianping.cat.home.service.client.entity.Domain;
import com.dianping.cat.home.service.client.entity.Method;
import com.dianping.cat.home.service.client.transform.DefaultJsonParser;
import com.dianping.cat.home.service.client.transform.DefaultLinker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultJsonParser {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private List<Object> m_entities = new ArrayList();
    private Class<?> m_entityClass;

    private DefaultJsonParser(Class<?> entityClass) {
        this.m_entityClass = entityClass;
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, InputStream in) throws IOException {
        return (T)DefaultJsonParser.parse(entityClass, (Reader)new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, Reader reader) throws IOException {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.onArrayBegin();
        parser.parse(new JsonReader(reader));
        parser.onArrayEnd();
        if (parser.m_entities.isEmpty()) {
            return null;
        }
        return (T)((IEntity)parser.m_entities.get(0));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, String json) throws IOException {
        return (T)DefaultJsonParser.parse(entityClass, (Reader)new StringReader(json));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, InputStream in) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, (Reader)new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, Reader reader) throws Exception {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.parse(new JsonReader(reader));
        return parser.m_entities;
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, String json) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, (Reader)new StringReader(json));
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    private Object createRootEntity() {
        try {
            Object entity = this.m_entityClass.newInstance();
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to create entity(%s) instance!", this.m_entityClass.getName()), e);
        }
    }

    private boolean isTopLevel() {
        return this.m_objs.size() == 1;
    }

    protected void onArrayBegin() {
        if (this.m_objs.isEmpty()) {
            this.m_objs.push(this.m_entities);
            this.m_tags.push("");
        }
    }

    protected void onArrayEnd() {
        this.m_objs.pop();
        this.m_tags.pop();
    }

    protected void onName(String name) {
        this.m_tags.push(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onObjectBegin() {
        if (this.isTopLevel()) {
            this.m_objs.push(this.createRootEntity());
            this.m_tags.push("");
            return;
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof ClientReport) {
                if ("domains".equals(tag)) {
                    this.m_objs.push(parent);
                    return;
                } else {
                    String parentTag;
                    String string = parentTag = this.m_tags.size() >= 2 ? (String)this.m_tags.get(this.m_tags.size() - 2) : null;
                    if (!"domains".equals(parentTag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    Domain domains = new Domain();
                    this.m_linker.onDomain((ClientReport)parent, domains);
                    this.m_objs.push(domains);
                }
                return;
            } else {
                if (!(parent instanceof Domain)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                if ("methods".equals(tag)) {
                    this.m_objs.push(parent);
                    return;
                } else {
                    String parentTag;
                    String string = parentTag = this.m_tags.size() >= 2 ? (String)this.m_tags.get(this.m_tags.size() - 2) : null;
                    if (!"methods".equals(parentTag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    Method methods = new Method();
                    this.m_linker.onMethod((Domain)parent, methods);
                    this.m_objs.push(methods);
                }
            }
        }
    }

    protected void onObjectEnd() {
        this.m_tags.pop();
        Object entity = this.m_objs.pop();
        if (this.isTopLevel()) {
            this.m_entities.add(entity);
        }
    }

    protected void onValue(String value) {
        Object parent = this.m_objs.peek();
        String tag = (String)this.m_tags.pop();
        if (parent instanceof ClientReport) {
            this.parseForClientReport((ClientReport)parent, tag, value);
        } else if (parent instanceof Domain) {
            this.parseForDomain((Domain)parent, tag, value);
        } else if (parent instanceof Method) {
            this.parseForMethod((Method)parent, tag, value);
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) under %s!", tag, parent));
        }
    }

    private void parse(JsonReader reader) throws IOException {
        block2: {
            try {
                reader.parse(this);
            }
            catch (EOFException e) {
                if (this.m_objs.size() <= 1) break block2;
                throw new EOFException(String.format("Unexpected end while parsing json! tags: %s.", this.m_tags));
            }
        }
        this.m_linker.finish();
    }

    public void parseForClientReport(ClientReport clientReport, String tag, String value) {
        if (!"domains".equals(tag)) {
            if ("domain".equals(tag)) {
                clientReport.setDomain(value);
            } else if ("start-time".equals(tag)) {
                clientReport.setStartTime(this.toDate(value, "yyyy-MM-dd HH:mm:ss"));
            } else if ("end-time".equals(tag)) {
                clientReport.setEndTime(this.toDate(value, "yyyy-MM-dd HH:mm:ss"));
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, clientReport, this.m_tags));
            }
        }
    }

    public void parseForDomain(Domain domain, String tag, String value) {
        if (!"methods".equals(tag)) {
            if ("id".equals(tag)) {
                domain.setId(value);
            } else if ("totalCount".equals(tag)) {
                domain.setTotalCount(((Long)this.convert(Long.class, value, (Object)0L)).longValue());
            } else if ("failureCount".equals(tag)) {
                domain.setFailureCount(((Long)this.convert(Long.class, value, (Object)0L)).longValue());
            } else if ("failurePercent".equals(tag)) {
                domain.setFailurePercent(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
            } else if ("sum".equals(tag)) {
                domain.setSum(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
            } else if ("avg".equals(tag)) {
                domain.setAvg(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
            } else {
                throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, domain, this.m_tags));
            }
        }
    }

    public void parseForMethod(Method method, String tag, String value) {
        if ("id".equals(tag)) {
            method.setId(value);
        } else if ("service".equals(tag)) {
            method.setService(value);
        } else if ("totalCount".equals(tag)) {
            method.setTotalCount(((Long)this.convert(Long.class, value, (Object)0L)).longValue());
        } else if ("failureCount".equals(tag)) {
            method.setFailureCount(((Long)this.convert(Long.class, value, (Object)0L)).longValue());
        } else if ("failurePercent".equals(tag)) {
            method.setFailurePercent(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
        } else if ("sum".equals(tag)) {
            method.setSum(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
        } else if ("avg".equals(tag)) {
            method.setAvg(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
        } else if ("qps".equals(tag)) {
            method.setQps(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
        } else if ("timeout".equals(tag)) {
            method.setTimeout(((Double)this.convert(Double.class, value, (Object)0.0)).doubleValue());
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, method, this.m_tags));
        }
    }

    protected Date toDate(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

