/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.transform;

import com.dianping.cat.home.service.IEntity;
import com.dianping.cat.home.service.IVisitor;
import com.dianping.cat.home.service.entity.Domain;
import com.dianping.cat.home.service.entity.ServiceReport;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private ServiceReport m_serviceReport;

    public DefaultMerger() {
    }

    public DefaultMerger(ServiceReport serviceReport) {
        this.m_serviceReport = serviceReport;
        this.m_objs.push(serviceReport);
    }

    public ServiceReport getServiceReport() {
        return this.m_serviceReport;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
        to.setTotalCount(from.getTotalCount());
        to.setFailureCount(from.getFailureCount());
        to.setFailurePercent(from.getFailurePercent());
        to.setSum(from.getSum());
        to.setAvg(from.getAvg());
        to.setQps(from.getQps());
    }

    protected void mergeServiceReport(ServiceReport to, ServiceReport from) {
        to.mergeAttributes(from);
    }

    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
    }

    public void visitServiceReport(ServiceReport from) {
        ServiceReport to = (ServiceReport)this.m_objs.peek();
        this.mergeServiceReport(to, from);
        this.visitServiceReportChildren(to, from);
    }

    protected void visitServiceReportChildren(ServiceReport to, ServiceReport from) {
        for (Domain source : from.getDomains().values()) {
            Domain target = to.findDomain(source.getId());
            if (target == null) {
                target = new Domain(source.getId());
                to.addDomain(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }
}

