/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.service.transform;

import com.dianping.cat.home.service.IVisitor;
import com.dianping.cat.home.service.entity.Domain;
import com.dianping.cat.home.service.entity.ServiceReport;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(ServiceReport serviceReport) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((ServiceReport)serviceReport, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(ServiceReport serviceReport, OutputStream out) {
        serviceReport.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        this.writeTag(2, 0);
        this.writeLong(domain.getTotalCount());
        this.writeTag(3, 0);
        this.writeLong(domain.getFailureCount());
        this.writeTag(4, 0);
        this.writeDouble(domain.getFailurePercent());
        this.writeTag(5, 0);
        this.writeDouble(domain.getSum());
        this.writeTag(6, 0);
        this.writeDouble(domain.getAvg());
        this.writeTag(7, 0);
        this.writeDouble(domain.getQps());
        this.writeTag(63, 3);
    }

    public void visitServiceReport(ServiceReport serviceReport) {
        this.writeTag(63, 0);
        if (serviceReport.getStartTime() != null) {
            this.writeTag(1, 1);
            this.writeDate(serviceReport.getStartTime());
        }
        if (serviceReport.getDomain() != null) {
            this.writeTag(2, 1);
            this.writeString(serviceReport.getDomain());
        }
        if (serviceReport.getEndTime() != null) {
            this.writeTag(3, 1);
            this.writeDate(serviceReport.getEndTime());
        }
        if (!serviceReport.getDomains().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(serviceReport.getDomains().size());
            for (Domain domain : serviceReport.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDouble(double value) {
        try {
            this.writeVarint(Double.doubleToLongBits(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLong(long value) {
        try {
            this.writeVarint(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

