/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.storage.transform;

import com.dianping.cat.home.storage.IEntity;
import com.dianping.cat.home.storage.IVisitor;
import com.dianping.cat.home.storage.entity.Link;
import com.dianping.cat.home.storage.entity.Storage;
import com.dianping.cat.home.storage.entity.StorageGroup;
import com.dianping.cat.home.storage.entity.StorageGroupConfig;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private StorageGroupConfig m_storageGroupConfig;

    public DefaultMerger() {
    }

    public DefaultMerger(StorageGroupConfig storageGroupConfig) {
        this.m_storageGroupConfig = storageGroupConfig;
        this.m_objs.push(storageGroupConfig);
    }

    public StorageGroupConfig getStorageGroupConfig() {
        return this.m_storageGroupConfig;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeLink(Link to, Link from) {
        to.mergeAttributes(from);
        to.getPars().addAll(from.getPars());
    }

    protected void mergeStorage(Storage to, Storage from) {
        to.mergeAttributes(from);
    }

    protected void mergeStorageGroup(StorageGroup to, StorageGroup from) {
        to.mergeAttributes(from);
    }

    protected void mergeStorageGroupConfig(StorageGroupConfig to, StorageGroupConfig from) {
        to.mergeAttributes(from);
    }

    public void visitLink(Link from) {
        Link to = (Link)this.m_objs.peek();
        this.mergeLink(to, from);
        this.visitLinkChildren(to, from);
    }

    protected void visitLinkChildren(Link to, Link from) {
    }

    public void visitStorage(Storage from) {
        Storage to = (Storage)this.m_objs.peek();
        this.mergeStorage(to, from);
        this.visitStorageChildren(to, from);
    }

    protected void visitStorageChildren(Storage to, Storage from) {
    }

    public void visitStorageGroup(StorageGroup from) {
        StorageGroup to = (StorageGroup)this.m_objs.peek();
        this.mergeStorageGroup(to, from);
        this.visitStorageGroupChildren(to, from);
    }

    protected void visitStorageGroupChildren(StorageGroup to, StorageGroup from) {
        if (from.getLink() != null) {
            Link target = to.getLink();
            if (target == null) {
                target = new Link();
                to.setLink(target);
            }
            this.m_objs.push(target);
            from.getLink().accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (Storage source : from.getStorages().values()) {
            Storage target = to.findStorage(source.getId());
            if (target == null) {
                target = new Storage(source.getId());
                to.addStorage(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitStorageGroupConfig(StorageGroupConfig from) {
        StorageGroupConfig to = (StorageGroupConfig)this.m_objs.peek();
        this.mergeStorageGroupConfig(to, from);
        this.visitStorageGroupConfigChildren(to, from);
    }

    protected void visitStorageGroupConfigChildren(StorageGroupConfig to, StorageGroupConfig from) {
        for (StorageGroup source : from.getStorageGroups().values()) {
            StorageGroup target = to.findStorageGroup(source.getId());
            if (target == null) {
                target = new StorageGroup(source.getId());
                to.addStorageGroup(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }
}

