/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.utilization.transform;

import com.dianping.cat.home.utilization.IVisitor;
import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.MachineState;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(UtilizationReport utilizationReport) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build((UtilizationReport)utilizationReport, (OutputStream)out);
        return out.toByteArray();
    }

    public static void build(UtilizationReport utilizationReport, OutputStream out) {
        utilizationReport.accept((IVisitor)new DefaultNativeBuilder(out));
    }

    public void visitApplicationState(ApplicationState applicationState) {
        if (applicationState.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(applicationState.getId());
        }
        this.writeTag(2, 0);
        this.writeLong(applicationState.getFailureCount());
        this.writeTag(3, 0);
        this.writeDouble(applicationState.getFailurePercent());
        this.writeTag(4, 0);
        this.writeLong(applicationState.getCount());
        this.writeTag(5, 0);
        this.writeDouble(applicationState.getMaxQps());
        this.writeTag(6, 0);
        this.writeDouble(applicationState.getAvg());
        this.writeTag(7, 0);
        this.writeDouble(applicationState.getSum());
        this.writeTag(8, 0);
        this.writeDouble(applicationState.getAvg95());
        this.writeTag(63, 3);
    }

    public void visitDomain(Domain domain) {
        if (domain.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(domain.getId());
        }
        this.writeTag(2, 0);
        this.writeInt(domain.getMachineNumber());
        if (domain.getCmdbId() != null) {
            this.writeTag(3, 1);
            this.writeString(domain.getCmdbId());
        }
        if (!domain.getMachineStates().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(domain.getMachineStates().size());
            for (MachineState machineState : domain.getMachineStates().values()) {
                machineState.accept(this.m_visitor);
            }
        }
        if (!domain.getApplicationStates().isEmpty()) {
            this.writeTag(34, 2);
            this.writeInt(domain.getApplicationStates().size());
            for (ApplicationState applicationState : domain.getApplicationStates().values()) {
                applicationState.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    public void visitMachineState(MachineState machineState) {
        if (machineState.getId() != null) {
            this.writeTag(1, 1);
            this.writeString(machineState.getId());
        }
        this.writeTag(2, 0);
        this.writeLong(machineState.getCount());
        this.writeTag(3, 0);
        this.writeDouble(machineState.getSum());
        this.writeTag(4, 0);
        this.writeDouble(machineState.getAvg());
        this.writeTag(5, 0);
        this.writeDouble(machineState.getAvgMax());
        this.writeTag(63, 3);
    }

    public void visitUtilizationReport(UtilizationReport utilizationReport) {
        this.writeTag(63, 0);
        if (utilizationReport.getDomain() != null) {
            this.writeTag(1, 1);
            this.writeString(utilizationReport.getDomain());
        }
        if (utilizationReport.getStartTime() != null) {
            this.writeTag(2, 1);
            this.writeDate(utilizationReport.getStartTime());
        }
        if (utilizationReport.getEndTime() != null) {
            this.writeTag(3, 1);
            this.writeDate(utilizationReport.getEndTime());
        }
        if (!utilizationReport.getDomains().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(utilizationReport.getDomains().size());
            for (Domain domain : utilizationReport.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeDate(Date value) {
        try {
            this.writeVarint(value.getTime());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDouble(double value) {
        try {
            this.writeVarint(Double.doubleToLongBits(value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLong(long value) {
        try {
            this.writeVarint(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

