/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.business;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.rule.entity.Config;
import com.dianping.cat.alarm.spi.AlertEntity;
import com.dianping.cat.alarm.spi.AlertManager;
import com.dianping.cat.alarm.spi.AlertType;
import com.dianping.cat.alarm.spi.rule.DataCheckEntity;
import com.dianping.cat.alarm.spi.rule.DataChecker;
import com.dianping.cat.config.business.BusinessConfigManager;
import com.dianping.cat.configuration.business.entity.BusinessItemConfig;
import com.dianping.cat.configuration.business.entity.BusinessReportConfig;
import com.dianping.cat.configuration.business.entity.CustomConfig;
import com.dianping.cat.helper.MetricType;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.business.BusinessReportGroup;
import com.dianping.cat.report.alert.business.BusinessReportGroupService;
import com.dianping.cat.report.alert.business.BusinessRuleConfigManager;
import com.dianping.cat.report.alert.config.BaseRuleHelper;
import com.dianping.cat.report.alert.spi.AlarmRule;
import com.dianping.cat.report.page.business.graph.CustomDataCalculator;
import com.dianping.cat.report.page.business.graph.CustomInfo;
import com.dianping.cat.report.page.business.task.BusinessKeyHelper;
import com.dianping.cat.report.page.metric.service.BaselineService;
import com.dianping.cat.service.ProjectService;
import com.dianping.cat.system.page.business.config.BusinessTagConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.tuple.Pair;

@Named
public class BusinessAlert
implements Threads.Task {
    public static final String DEFAULT_TAG = "\u4e1a\u52a1\u5927\u76d8";
    private static final long DURATION = 60000L;
    private static final int DATA_AREADY_MINUTE = 1;
    @Inject
    protected BaseRuleHelper m_baseRuleHelper;
    @Inject
    private BusinessRuleConfigManager m_alertConfigManager;
    @Inject
    private BusinessConfigManager m_configManager;
    @Inject
    private BusinessTagConfigManager m_tagConfigManager;
    @Inject
    private BusinessReportGroupService m_service;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private AlertManager m_sendManager;
    @Inject
    private BusinessKeyHelper m_keyHelper;
    @Inject
    private BaselineService m_baselineService;
    @Inject
    private DataChecker m_dataChecker;
    @Inject
    private CustomDataCalculator m_customDataCalculator;

    private void buidMonitorConfigs(String domain, String key, Map<String, Map<MetricType, List<Config>>> monitorConfigs, Map<MetricType, List<Config>> defaultRules) {
        HashMap<MetricType, List> monitorConfigsByItem = new HashMap<MetricType, List>();
        for (MetricType type : MetricType.values()) {
            List configs = this.m_alertConfigManager.queryConfigs(domain, key, type);
            if (configs == null || configs.size() <= 0) continue;
            monitorConfigsByItem.put(type, configs);
        }
        if (monitorConfigsByItem.isEmpty()) {
            monitorConfigs.put(key, defaultRules);
        } else {
            monitorConfigs.put(key, monitorConfigsByItem);
        }
    }

    private AlarmRule buildMonitorConfigs(String domain, BusinessReportConfig businessReportConfig) {
        Map defaultRules;
        String key;
        HashMap monitorConfigs = new HashMap();
        Map itemConfigs = businessReportConfig.getBusinessItemConfigs();
        Map customConfigs = businessReportConfig.getCustomConfigs();
        for (BusinessItemConfig config : itemConfigs.values()) {
            if (!this.needAlert(config, domain)) continue;
            key = config.getId();
            defaultRules = this.m_alertConfigManager.getDefaultRules(config);
            this.buidMonitorConfigs(domain, key, monitorConfigs, defaultRules);
        }
        for (BusinessItemConfig config : customConfigs.values()) {
            if (!this.needAlert((CustomConfig)config, domain)) continue;
            key = config.getId();
            defaultRules = this.m_alertConfigManager.getDefaultRulesForCustomItem();
            this.buidMonitorConfigs(domain, key, monitorConfigs, defaultRules);
        }
        return new AlarmRule(monitorConfigs);
    }

    private int calAlreadyMinute() {
        long current = System.currentTimeMillis() / 1000L / 60L;
        int minute = (int)(current % 60L) - 1;
        return minute;
    }

    public String getName() {
        return AlertType.Business.getName();
    }

    private boolean needAlert(BusinessItemConfig config, String domain) {
        if (config.isAlarm()) {
            return true;
        }
        Set tags = (Set)this.m_tagConfigManager.findTagByDomain(domain).get(config.getId());
        return tags != null && tags.contains(DEFAULT_TAG);
    }

    private boolean needAlert(CustomConfig config, String domain) {
        if (config.isAlarm()) {
            return true;
        }
        Set tags = (Set)this.m_tagConfigManager.findTagByDomain(domain).get(config.getId());
        return tags != null && tags.contains(DEFAULT_TAG);
    }

    private List<DataCheckEntity> processBusinessItem(BusinessReportGroup reportGroup, Map<MetricType, List<Config>> alertConfig, String id, int minute, String domain) {
        ArrayList<DataCheckEntity> results = new ArrayList<DataCheckEntity>();
        for (Map.Entry<MetricType, List<Config>> alertConfigEntry : alertConfig.entrySet()) {
            MetricType type = alertConfigEntry.getKey();
            String metricKey = this.m_keyHelper.generateKey(id, domain, type.getName());
            List tmpResults = this.processMetricType(minute, alertConfigEntry.getValue(), reportGroup, metricKey, type);
            results.addAll(tmpResults);
        }
        return results;
    }

    private List<DataCheckEntity> processCustomItem(BusinessReportGroup currentReportGroup, List<Config> configs, int minute, String key, CustomConfig customConfig, int maxDuration) {
        try {
            Pair conditionPair = this.m_baseRuleHelper.convertConditions(configs);
            HashMap<String, double[]> businessItemDataCache = new HashMap<String, double[]>();
            HashMap<String, double[]> baseLineCache = new HashMap<String, double[]>();
            HashMap<String, BusinessReportGroup> reportGroupCache = new HashMap<String, BusinessReportGroup>();
            reportGroupCache.put(this.m_keyHelper.getDomain(key), currentReportGroup);
            if (conditionPair != null) {
                String domain;
                int ruleMinute = (Integer)conditionPair.getKey();
                String pattern = customConfig.getPattern();
                List customInfos = this.m_customDataCalculator.translatePattern(pattern);
                for (CustomInfo customInfo : customInfos) {
                    domain = customInfo.getDomain();
                    if (reportGroupCache.containsKey(domain)) continue;
                    BusinessReportGroup tmpReportGroup = this.m_service.prepareDatas(domain, minute, maxDuration);
                    reportGroupCache.put(domain, tmpReportGroup);
                }
                for (CustomInfo customInfo : customInfos) {
                    domain = customInfo.getDomain();
                    String type = customInfo.getType();
                    String id = customInfo.getKey();
                    String metricKey = this.m_keyHelper.generateKey(id, domain, type);
                    BusinessReportGroup reportGroup = (BusinessReportGroup)reportGroupCache.get(domain);
                    double[] value = reportGroup.extractData(minute, ruleMinute, id, MetricType.getTypeByName((String)type));
                    double[] baseline = this.m_baselineService.queryBaseline(minute, ruleMinute, metricKey, "business");
                    businessItemDataCache.put(metricKey, value);
                    baseLineCache.put(metricKey, baseline);
                }
                double[] currentData = this.m_customDataCalculator.calculate(pattern, customInfos, businessItemDataCache, ruleMinute);
                double[] currentBaseLine = this.m_customDataCalculator.calculate(pattern, customInfos, baseLineCache, ruleMinute);
                List conditions = (List)conditionPair.getValue();
                return this.m_dataChecker.checkData(currentData, currentBaseLine, conditions);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new ArrayList<DataCheckEntity>();
    }

    private void processDomain(String domain) {
        BusinessReportGroup reportGroup;
        BusinessReportConfig businessReportConfig = this.m_configManager.queryConfigByDomain(domain);
        AlarmRule monitorConfigs = this.buildMonitorConfigs(domain, businessReportConfig);
        int minute = this.calAlreadyMinute();
        int maxDuration = monitorConfigs.calMaxRuleMinute();
        if (maxDuration > 0 && (reportGroup = this.m_service.prepareDatas(domain, minute, maxDuration)).isDataReady()) {
            Map alertConfig;
            String id;
            Collection configs = businessReportConfig.getBusinessItemConfigs().values();
            Collection customConfigs = businessReportConfig.getCustomConfigs().values();
            for (BusinessItemConfig itemConfig : configs) {
                id = itemConfig.getId();
                alertConfig = (Map)monitorConfigs.getConfigs().get(id);
                if (alertConfig == null) continue;
                List results = this.processBusinessItem(reportGroup, alertConfig, id, minute, domain);
                this.sendBusinessAlerts(domain, itemConfig.getId(), results);
            }
            for (CustomConfig customConfig : customConfigs) {
                id = customConfig.getId();
                alertConfig = (Map)monitorConfigs.getConfigs().get(id);
                MetricType customType = MetricType.AVG;
                if (alertConfig == null) continue;
                String metricKey = this.m_keyHelper.generateKey(id, domain, customType.getName());
                List results = this.processCustomItem(reportGroup, (List)alertConfig.get(customType), minute, metricKey, customConfig, maxDuration);
                this.sendBusinessAlerts(domain, customConfig.getId(), results);
            }
        }
    }

    private List<DataCheckEntity> processMetricType(int minute, List<Config> configs, BusinessReportGroup reportGroup, String metricKey, MetricType type) {
        Pair conditionPair = this.m_baseRuleHelper.convertConditions(configs);
        if (conditionPair != null) {
            int ruleMinute = (Integer)conditionPair.getKey();
            double[] value = reportGroup.extractData(minute, ruleMinute, this.m_keyHelper.getBusinessItemId(metricKey), type);
            double[] baseline = this.m_baselineService.queryBaseline(minute, ruleMinute, metricKey, "business");
            List conditions = (List)conditionPair.getValue();
            return this.m_dataChecker.checkData(value, baseline, conditions);
        }
        return new ArrayList<DataCheckEntity>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            Transaction t = Cat.newTransaction((String)"AlertBusiness", (String)TimeHelper.getMinuteStr());
            long current = System.currentTimeMillis();
            try {
                Set domains = this.m_projectService.findAllDomains();
                for (String domain : domains) {
                    try {
                        this.processDomain(domain);
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                Cat.logError((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    private void sendBusinessAlerts(String domain, String metricName, List<DataCheckEntity> alertResults) {
        for (DataCheckEntity alertResult : alertResults) {
            AlertEntity entity = new AlertEntity();
            entity.setDate(alertResult.getAlertTime()).setContent(alertResult.getContent()).setLevel(alertResult.getAlertLevel());
            entity.setMetric(metricName).setType(this.getName()).setDomain(domain).setGroup(domain);
            entity.setContactGroup(domain);
            this.m_sendManager.addAlert(entity);
        }
    }

    public void shutdown() {
    }
}

