/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.business;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.rule.entity.Condition;
import com.dianping.cat.alarm.rule.entity.Config;
import com.dianping.cat.alarm.rule.entity.MonitorRules;
import com.dianping.cat.alarm.rule.entity.Rule;
import com.dianping.cat.alarm.rule.entity.SubCondition;
import com.dianping.cat.alarm.rule.transform.DefaultJsonParser;
import com.dianping.cat.alarm.rule.transform.DefaultSaxParser;
import com.dianping.cat.configuration.business.entity.BusinessItemConfig;
import com.dianping.cat.core.config.BusinessConfig;
import com.dianping.cat.core.config.BusinessConfigDao;
import com.dianping.cat.core.config.BusinessConfigEntity;
import com.dianping.cat.helper.MetricType;
import com.dianping.cat.task.TimerSyncTask;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class BusinessRuleConfigManager
implements Initializable {
    private static final String ALERT_CONFIG = "alert";
    private static final String TYPE = "type";
    private static final String SPLITTER = ":";
    Map<String, MonitorRules> m_rules = new ConcurrentHashMap();
    @Inject
    private BusinessConfigDao m_configDao;

    private List<Config> buildDefaultConfigs() {
        ArrayList<Config> configs = new ArrayList<Config>();
        Config config = new Config();
        config.setStarttime("00:00");
        config.setEndtime("24:00");
        Condition condition = new Condition();
        SubCondition descPerSubcon = new SubCondition();
        SubCondition descValSubcon = new SubCondition();
        SubCondition flucPerSubcon = new SubCondition();
        descPerSubcon.setType("DescPer").setText("50");
        descValSubcon.setType("DescVal").setText("100");
        flucPerSubcon.setType("FluDescPer").setText("20");
        condition.addSubCondition(descPerSubcon).addSubCondition(descValSubcon).addSubCondition(flucPerSubcon);
        config.addCondition(condition);
        configs.add(config);
        return configs;
    }

    private String generateRuleId(String key, String type) {
        return key + SPLITTER + type;
    }

    public Map<MetricType, List<Config>> getDefaultRules(BusinessItemConfig config) {
        HashMap<MetricType, List<Config>> configs = new HashMap<MetricType, List<Config>>();
        if (config.isShowAvg()) {
            configs.put(MetricType.AVG, this.buildDefaultConfigs());
        }
        if (config.isShowCount()) {
            configs.put(MetricType.COUNT, this.buildDefaultConfigs());
        }
        if (config.isShowSum()) {
            configs.put(MetricType.SUM, this.buildDefaultConfigs());
        }
        return configs;
    }

    public Map<MetricType, List<Config>> getDefaultRulesForCustomItem() {
        HashMap<MetricType, List<Config>> configs = new HashMap<MetricType, List<Config>>();
        configs.put(MetricType.AVG, this.buildDefaultConfigs());
        return configs;
    }

    public void initialize() throws InitializationException {
        this.loadData();
        TimerSyncTask.getInstance().register((TimerSyncTask.SyncHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadData() {
        try {
            List configs = this.m_configDao.findByName(ALERT_CONFIG, BusinessConfigEntity.READSET_FULL);
            ConcurrentHashMap<String, MonitorRules> rules = new ConcurrentHashMap<String, MonitorRules>();
            for (BusinessConfig config : configs) {
                try {
                    String doamin = config.getDomain();
                    MonitorRules rule = DefaultSaxParser.parse((String)config.getContent());
                    rules.put(doamin, rule);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
            this.m_rules = rules;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
    }

    public List<Config> queryConfigs(String domain, String key, MetricType type) {
        String typeName = type.getName();
        Rule rule = this.queryRule(domain, key, typeName);
        ArrayList<Config> configs = new ArrayList<Config>();
        if (rule != null && rule.getDynamicAttribute(TYPE).equals(typeName)) {
            configs.addAll(rule.getConfigs());
        }
        return configs;
    }

    public MonitorRules queryMonitorRules(String domain) {
        return (MonitorRules)this.m_rules.get(domain);
    }

    public Rule queryRule(String domain, String key, String type) {
        MonitorRules rule = (MonitorRules)this.m_rules.get(domain);
        if (rule != null) {
            return rule.findRule(this.generateRuleId(key, type));
        }
        return null;
    }

    public void updateRule(String domain, String key, String configsStr, String type) {
        try {
            Rule rule = new Rule(this.generateRuleId(key, type));
            List configs = DefaultJsonParser.parseArray(Config.class, (String)configsStr);
            for (Config config : configs) {
                rule.addConfig(config);
            }
            rule.setDynamicAttribute(TYPE, type);
            boolean isExist = true;
            MonitorRules domainRule = (MonitorRules)this.m_rules.get(domain);
            if (domainRule == null) {
                domainRule = new MonitorRules();
                this.m_rules.put(domain, domainRule);
                isExist = false;
            }
            domainRule.getRules().put(rule.getId(), rule);
            BusinessConfig proto = this.m_configDao.createLocal();
            proto.setDomain(domain);
            proto.setContent(domainRule.toString());
            proto.setName(ALERT_CONFIG);
            proto.setUpdatetime(new Date());
            if (isExist) {
                this.m_configDao.updateBaseConfigByDomain(proto, BusinessConfigEntity.UPDATESET_FULL);
            } else {
                this.m_configDao.insert(proto);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    static /* synthetic */ void access$000(BusinessRuleConfigManager x0) {
        x0.loadData();
    }
}

