/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.config;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.rule.entity.Condition;
import com.dianping.cat.alarm.rule.entity.Config;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.unidal.lookup.annotation.Named;
import org.unidal.tuple.Pair;

@Named
public class BaseRuleHelper {
    public Pair<Integer, List<Condition>> convertConditions(List<Config> configs) {
        int maxMinute = 0;
        ArrayList conditions = new ArrayList();
        for (Config config : configs) {
            if (!this.checkTimeValidate(config)) continue;
            List tmpConditions = config.getConditions();
            conditions.addAll(tmpConditions);
            for (Condition con : tmpConditions) {
                int tmpMinute = con.getMinute();
                if (tmpMinute <= maxMinute) continue;
                maxMinute = tmpMinute;
            }
        }
        if (maxMinute > 0) {
            return new Pair((Object)maxMinute, conditions);
        }
        return null;
    }

    private boolean checkTimeValidate(Config config) {
        try {
            return this.compareTime(config.getStarttime(), config.getEndtime());
        }
        catch (Exception ex) {
            Cat.logError((String)("throw exception when judge time: " + config.toString()), (Throwable)ex);
            return false;
        }
    }

    private boolean compareTime(String start, String end) {
        String[] startTime = start.split(":");
        int hourStart = Integer.parseInt(startTime[0]);
        int minuteStart = Integer.parseInt(startTime[1]);
        int startMinute = hourStart * 60 + minuteStart;
        String[] endTime = end.split(":");
        int hourEnd = Integer.parseInt(endTime[0]);
        int minuteEnd = Integer.parseInt(endTime[1]);
        int endMinute = hourEnd * 60 + minuteEnd;
        Calendar cal = Calendar.getInstance();
        int current = cal.get(11) * 60 + cal.get(12);
        return current >= startMinute && current <= endMinute;
    }
}

