/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.exception;

import com.dianping.cat.alarm.spi.AlertLevel;
import com.dianping.cat.home.exception.entity.ExceptionLimit;
import com.dianping.cat.report.alert.exception.AlertExceptionBuilder;
import com.dianping.cat.report.alert.exception.ExceptionRuleConfigManager;
import com.dianping.cat.report.page.dependency.TopMetric;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.tuple.Pair;

@Named
public class AlertExceptionBuilder {
    @Inject
    private ExceptionRuleConfigManager m_exceptionConfigManager;

    public Map<String, List<AlertException>> buildAlertExceptions(List<TopMetric.Item> items) {
        LinkedHashMap<String, List<AlertException>> alertExceptions = new LinkedHashMap<String, List<AlertException>>();
        for (TopMetric.Item item : items) {
            List domainAlertExceptions = this.buildDomainAlertExceptions(item);
            if (domainAlertExceptions.isEmpty()) continue;
            alertExceptions.put(item.getDomain(), domainAlertExceptions);
        }
        return alertExceptions;
    }

    private List<AlertException> buildDomainAlertExceptions(TopMetric.Item item) {
        String domain = item.getDomain();
        ArrayList<AlertException> alertExceptions = new ArrayList<AlertException>();
        Pair totalLimitPair = this.queryDomainTotalLimit(domain);
        double totalWarnLimit = (Double)totalLimitPair.getKey();
        double totalErrorLimit = (Double)totalLimitPair.getValue();
        double totalException = 0.0;
        for (Map.Entry entry : item.getException().entrySet()) {
            String exceptionName = (String)entry.getKey();
            double value = (Double)entry.getValue();
            Pair limitPair = this.queryDomainExceptionLimit(domain, exceptionName);
            double warnLimit = (Double)limitPair.getKey();
            double errorLimit = (Double)limitPair.getValue();
            totalException += value;
            if (errorLimit > 0.0 && value >= errorLimit) {
                alertExceptions.add(new AlertException(this, exceptionName, AlertLevel.ERROR, value));
                continue;
            }
            if (!(warnLimit > 0.0) || !(value >= warnLimit)) continue;
            alertExceptions.add(new AlertException(this, exceptionName, AlertLevel.WARNING, value));
        }
        if (totalErrorLimit > 0.0 && totalException >= totalErrorLimit) {
            alertExceptions.add(new AlertException(this, ExceptionRuleConfigManager.TOTAL_STRING, AlertLevel.ERROR, totalException));
        } else if (totalWarnLimit > 0.0 && totalException >= totalWarnLimit) {
            alertExceptions.add(new AlertException(this, ExceptionRuleConfigManager.TOTAL_STRING, AlertLevel.WARNING, totalException));
        }
        return alertExceptions;
    }

    private Pair<Double, Double> queryDomainExceptionLimit(String domain, String exceptionName) {
        ExceptionLimit exceptionLimit = this.m_exceptionConfigManager.queryExceptionLimit(domain, exceptionName);
        Pair limits = new Pair();
        double warnLimit = -1.0;
        double errorLimit = -1.0;
        if (exceptionLimit != null) {
            warnLimit = exceptionLimit.getWarning();
            errorLimit = exceptionLimit.getError();
        }
        limits.setKey((Object)warnLimit);
        limits.setValue((Object)errorLimit);
        return limits;
    }

    private Pair<Double, Double> queryDomainTotalLimit(String domain) {
        ExceptionLimit totalExceptionLimit = this.m_exceptionConfigManager.queryTotalLimitByDomain(domain);
        Pair limits = new Pair();
        double totalWarnLimit = -1.0;
        double totalErrorLimit = -1.0;
        if (totalExceptionLimit != null) {
            totalWarnLimit = totalExceptionLimit.getWarning();
            totalErrorLimit = totalExceptionLimit.getError();
        }
        limits.setKey((Object)totalWarnLimit);
        limits.setValue((Object)totalErrorLimit);
        return limits;
    }
}

