/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.exception;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.spi.AlertEntity;
import com.dianping.cat.alarm.spi.AlertType;
import com.dianping.cat.alarm.spi.decorator.ProjectDecorator;
import com.dianping.cat.report.alert.summary.AlertSummaryExecutor;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.annotation.Inject;

public class ExceptionDecorator
extends ProjectDecorator
implements Initializable {
    public static final String ID = AlertType.Exception.getName();
    public Configuration m_configuration;
    protected DateFormat m_linkFormat = new SimpleDateFormat("yyyyMMddHH");
    @Inject
    private AlertSummaryExecutor m_executor;

    public String generateContent(AlertEntity alert) {
        Map dataMap = this.generateExceptionMap(alert);
        Map summary = this.m_executor.getSummaryData(alert.getGroup(), alert.getDate());
        Map failure = (Map)summary.get("FailureDecorator");
        dataMap.putAll(failure);
        StringWriter sw = new StringWriter(5000);
        try {
            Template t = this.m_configuration.getTemplate("errorInfoMarkdown.ftl");
            t.process((Object)dataMap, (Writer)sw);
        }
        catch (Exception e) {
            Cat.logError((String)("build exception content error:" + alert.toString()), (Throwable)e);
        }
        return sw.toString();
    }

    protected Map<Object, Object> generateExceptionMap(AlertEntity alert) {
        String domain = alert.getGroup();
        String contactInfo = this.buildContactInfo(domain);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("domain", domain);
        map.put("content", alert.getContent());
        map.put("date", this.m_format.format(alert.getDate()));
        map.put("linkDate", this.m_linkFormat.format(alert.getDate()));
        map.put("contactInfo", contactInfo);
        return map;
    }

    public String generateTitle(AlertEntity alert) {
        StringBuilder sb = new StringBuilder();
        sb.append("[CAT\u5f02\u5e38\u544a\u8b66] [\u9879\u76ee: ").append(alert.getGroup()).append("]");
        return sb.toString();
    }

    public String getId() {
        return ID;
    }

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(this.getClass(), "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

