/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.heartbeat;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.rule.entity.Config;
import com.dianping.cat.alarm.rule.entity.MetricItem;
import com.dianping.cat.alarm.rule.entity.Rule;
import com.dianping.cat.report.alert.spi.config.BaseRuleConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.unidal.lookup.annotation.Named;

@Named
public class HeartbeatRuleConfigManager
extends BaseRuleConfigManager
implements Initializable {
    private static final String CONFIG_NAME = "heartbeatRuleConfig";

    private void addRuleToMap(Rule rule, String metric, int priority, Map<String, Map<Integer, List<Rule>>> rules) {
        List<Rule> ruleList;
        Map<Integer, List<Rule>> rulesByPriority = rules.get(metric);
        if (rulesByPriority == null) {
            rulesByPriority = new HashMap<Integer, List<Rule>>();
            rules.put(metric, rulesByPriority);
        }
        if ((ruleList = rulesByPriority.get(priority)) == null) {
            ruleList = new ArrayList<Rule>();
            rulesByPriority.put(priority, ruleList);
        }
        ruleList.add(rule);
    }

    private Map<String, List<Config>> extractConfigs(String domain, Map<String, Map<Integer, List<Rule>>> rulesByMetricPriority) {
        HashMap<String, List<Config>> result = new HashMap<String, List<Config>>();
        for (Map.Entry<String, Map<Integer, List<Rule>>> entry : rulesByMetricPriority.entrySet()) {
            String metric = entry.getKey();
            List rules = this.getMaxPriorityRules(entry.getValue());
            ArrayList configs = new ArrayList();
            for (Rule rule : rules) {
                configs.addAll(rule.getConfigs());
                String nameValuePairs = "product=" + domain + "&metricKey=" + metric;
                Cat.logEvent((String)("FindRule:" + this.getConfigName()), (String)rule.getId(), (String)"0", (String)nameValuePairs);
            }
            result.put(metric, configs);
        }
        return result;
    }

    protected String getConfigName() {
        return CONFIG_NAME;
    }

    public Map<String, List<Config>> queryConfigsByDomain(String domain) {
        HashMap rules = new HashMap();
        for (Rule rule : this.m_config.getRules().values()) {
            for (MetricItem metricItem : rule.getMetricItems()) {
                String domainPattern = metricItem.getProductText();
                int matchLevel = this.validateRegex(domainPattern, domain);
                if (matchLevel <= 0) continue;
                String metric = metricItem.getMetricItemText();
                this.addRuleToMap(rule, metric, matchLevel, rules);
            }
        }
        return this.extractConfigs(domain, rules);
    }
}

