/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.summary.build;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.report.alert.summary.build.SummaryBuilder;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.page.problem.transform.PieGraphChartVisitor;
import com.dianping.cat.report.page.problem.transform.ProblemStatistics;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=SummaryBuilder.class, value="FailureDecorator")
public class FailureSummaryBuilder
extends SummaryBuilder {
    public static final String ID = "FailureDecorator";
    @Inject(type=ModelService.class, value={"problem"})
    private ModelService<ProblemReport> m_service;

    private void addDistributeInfo(Map<Object, Object> resultMap, ProblemReport report) {
        PieGraphChartVisitor pieChart = new PieGraphChartVisitor("error", null);
        HashMap<String, Double> distributes = new HashMap<String, Double>();
        pieChart.visitProblemReport(report);
        for (PieChart.Item item : pieChart.getPieChart().getItems()) {
            distributes.put(item.getTitle(), item.getNumber());
        }
        resultMap.put("distributeMap", distributes);
    }

    private void addFailureInfo(Map<Object, Object> resultMap, ProblemReport report) {
        ProblemStatistics problemStatistics = new ProblemStatistics();
        problemStatistics.setAllIp(true);
        problemStatistics.visitProblemReport(report);
        ProblemStatistics.TypeStatistics failureStatus = (ProblemStatistics.TypeStatistics)problemStatistics.getStatus().get("error");
        if (failureStatus != null) {
            HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
            for (ProblemStatistics.StatusStatistics status : failureStatus.getStatus().values()) {
                statusMap.put(status.getStatus(), status.getCount());
            }
            resultMap.put("count", failureStatus.getCount());
            resultMap.put("statusMap", statusMap);
        }
    }

    public Map<Object, Object> generateModel(String domain, Date endTime) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        ModelRequest request = new ModelRequest(domain, this.getCurrentHour()).setProperty("queryType", "view");
        request.setProperty("type", "error");
        ProblemReport report = null;
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            report = (ProblemReport)response.getModel();
        }
        try {
            this.addFailureInfo(result, report);
            this.addDistributeInfo(result, report);
        }
        catch (Exception ex) {
            Cat.logError((Throwable)ex);
        }
        return result;
    }

    private long getCurrentHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public String getID() {
        return ID;
    }

    protected String getTemplateAddress() {
        return "errorInfo.ftl";
    }
}

