/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.graph.metric;

import com.dianping.cat.alarm.spi.AlertManager;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.metric.DataExtractor;
import com.dianping.cat.report.page.metric.service.BaselineService;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.lookup.annotation.Inject;

public abstract class AbstractGraphCreator
implements LogEnabled {
    @Inject
    protected BaselineService m_baselineService;
    @Inject
    protected DataExtractor m_dataExtractor;
    @Inject
    protected AlertManager m_alertManager;
    protected int m_lastMinute = 6;
    protected int m_extraTime = 1;
    protected Logger m_logger;

    protected void addLastMinuteData(Map<Long, Double> current, Map<Long, Double> all, int minute, Date end) {
        int step = this.m_dataExtractor.getStep();
        if (step == 1) {
            return;
        }
        long endTime = 0L;
        long currentTime = System.currentTimeMillis();
        endTime = end.getTime() > currentTime ? currentTime - currentTime % 60000L - (long)this.m_extraTime * 60000L : end.getTime();
        long start = endTime - (long)minute * 60000L;
        HashSet<Long> sets = new HashSet<Long>();
        for (Map.Entry<Long, Double> entry : current.entrySet()) {
            if (entry.getKey() < start) continue;
            sets.add(entry.getKey());
        }
        for (Long temp : sets) {
            current.remove(temp);
        }
        for (int i = minute; i > 0; --i) {
            long time = endTime - (long)i * 60000L;
            Double value = all.get(time);
            if (value == null) continue;
            current.put(time, value);
        }
    }

    public Map<Long, Double> buildNoneData(Date startDate, Date endDate, int step) {
        int n = 0;
        long current = System.currentTimeMillis();
        n = endDate.getTime() > current ? (int)((double)(current - startDate.getTime()) / 60000.0) : (int)((double)(endDate.getTime() - startDate.getTime()) / 60000.0);
        double[] noneData = new double[n];
        Map currentData = this.convertToMap(noneData, startDate, step);
        return currentData;
    }

    protected String buildUnit(String chartTitle) {
        if (this.isFlowMetric(chartTitle)) {
            return "\u6d41\u91cf(MB/\u79d2)";
        }
        return "value/\u5206\u949f";
    }

    protected double[] convert(double[] value, int removeLength) {
        int length = value.length;
        int newLength = length - removeLength;
        double[] result = new double[newLength];
        for (int i = 0; i < newLength; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    protected void convertFlowMetric(LineChart lineChart, Map<Long, Double> current, String key) {
        if (this.isFlowMetric(lineChart.getId())) {
            LinkedHashMap<Long, Double> convertedData = new LinkedHashMap<Long, Double>();
            for (Map.Entry<Long, Double> currentEntry : current.entrySet()) {
                double result = currentEntry.getValue() / 1048576.0 / 60.0 / 8.0;
                convertedData.put(currentEntry.getKey(), result);
            }
            lineChart.add(key, convertedData);
        } else {
            lineChart.add(key, current);
        }
    }

    protected Map<Long, Double> convertToMap(double[] data, Date start, int step) {
        LinkedHashMap<Long, Double> map = new LinkedHashMap<Long, Double>();
        int length = data.length;
        long startTime = start.getTime();
        for (int i = 0; i < length; ++i) {
            map.put(startTime + (long)(step * i) * 60000L, data[i]);
        }
        return map;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private boolean isCurrentMode(Date date) {
        Date current = TimeHelper.getCurrentHour();
        return current.getTime() == date.getTime() - 3600000L;
    }

    protected boolean isFlowMetric(String title) {
        return title.toLowerCase().contains("flow");
    }

    protected void mergeMap(Map<String, double[]> all, Map<String, double[]> item, int size, int index) {
        for (Map.Entry<String, double[]> entry : item.entrySet()) {
            String key = entry.getKey();
            double[] value = entry.getValue();
            double[] result = all.get(key);
            if (result == null) {
                result = new double[size];
                all.put(key, result);
            }
            if (value == null) continue;
            int length = value.length;
            int pos = index * 60;
            for (int i = 0; i < length && pos < size; ++i, ++pos) {
                result[pos] = value[i];
            }
        }
    }

    protected void put(Map<String, LineChart> charts, Map<String, LineChart> result, String key) {
        LineChart value = charts.get(key);
        if (value != null) {
            result.put(key, charts.get(key));
        }
    }

    protected void putKey(Map<String, double[]> datas, Map<String, double[]> values, String key) {
        double[] value = datas.get(key);
        if (value == null) {
            value = new double[60];
        }
        values.put(key, value);
    }

    protected double[] queryBaseline(String name, String key, Date start, Date end) {
        int size = (int)((end.getTime() - start.getTime()) / 60000L);
        double[] result = new double[size];
        int index = 0;
        long endLong = end.getTime();
        for (long startLong = start.getTime(); startLong < endLong; startLong += 3600000L) {
            double[] values = this.m_baselineService.queryHourlyBaseline(name, key, new Date(startLong));
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    result[index * 60 + j] = values[j];
                }
            }
            ++index;
        }
        return result;
    }

    public Map<String, double[]> removeFutureData(Date endDate, Map<String, double[]> allCurrentValues) {
        if (this.isCurrentMode(endDate)) {
            LinkedHashMap<String, double[]> newCurrentValues = new LinkedHashMap<String, double[]>();
            int step = this.m_dataExtractor.getStep();
            if (step <= 0) {
                return allCurrentValues;
            }
            int minute = Calendar.getInstance().get(12);
            int removeLength = 60 / step - minute / step;
            for (Map.Entry<String, double[]> entry : allCurrentValues.entrySet()) {
                String key = entry.getKey();
                double[] value = entry.getValue();
                newCurrentValues.put(key, this.convert(value, removeLength));
            }
            return newCurrentValues;
        }
        return allCurrentValues;
    }
}

