/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.graph.metric;

import java.util.ListIterator;
import java.util.Stack;

public class Operation {
    private String src;

    public Operation(String src) {
        this.src = src;
    }

    public double calculate(double a, double b, char op) {
        switch (op) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '/': {
                return a / b;
            }
        }
        return -1.0;
    }

    private String getPostfix() {
        Stack<String> stk = new Stack<String>();
        String postfix = new String();
        int i = 0;
        while (i < this.src.length()) {
            if (Character.isDigit(this.src.charAt(i)) || this.src.charAt(i) == '.') {
                postfix = postfix + " ";
                do {
                    postfix = postfix + this.src.charAt(i++);
                } while (i < this.src.length() && Character.isDigit(this.src.charAt(i)));
                postfix = postfix + " ";
                continue;
            }
            char op = this.src.charAt(i++);
            switch (op) {
                case '(': {
                    stk.push("(");
                    break;
                }
                case ')': {
                    while (stk.peek() != "(") {
                        String tmp = (String)stk.pop();
                        postfix = postfix + tmp;
                        if (tmp.length() != 1 || !this.isOperator(tmp.charAt(0))) continue;
                        postfix = postfix + " ";
                    }
                    stk.pop();
                    postfix = postfix + " ";
                    break;
                }
                case '+': 
                case '-': {
                    while (!stk.empty() && stk.peek() != "(") {
                        postfix = postfix + (String)stk.pop() + " ";
                    }
                    stk.push(new Character(op).toString());
                    break;
                }
                case '*': 
                case '/': {
                    while (!(stk.empty() || stk.peek() != "*" && stk.peek() != "/")) {
                        postfix = postfix + (String)stk.pop() + " ";
                    }
                    stk.push(new Character(op).toString());
                }
            }
        }
        ListIterator it = stk.listIterator(stk.size());
        while (it.hasPrevious()) {
            postfix = postfix + (String)it.previous() + " ";
        }
        return postfix.trim().replaceAll(" +\\.", ".");
    }

    public double getResult() {
        String postfix = this.getPostfix();
        Stack<String> stk = new Stack<String>();
        String[] parts = postfix.split(" +");
        double result = 0.0;
        for (int i = 0; i < parts.length; ++i) {
            char tmp = parts[i].charAt(0);
            if (!this.isOperator(tmp)) {
                stk.push(parts[i]);
                continue;
            }
            double a = Double.parseDouble((String)stk.pop());
            double b = Double.parseDouble((String)stk.pop());
            result = this.calculate(b, a, tmp);
            stk.push(String.valueOf(result));
        }
        return result;
    }

    private boolean isOperator(char op) {
        return op == '+' || op == '-' || op == '*' || op == '/';
    }
}

