/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.alert;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.Alert;
import com.dianping.cat.alarm.AlertDao;
import com.dianping.cat.alarm.AlertEntity;
import com.dianping.cat.alarm.spi.AlertChannel;
import com.dianping.cat.alarm.spi.sender.SendMessageEntity;
import com.dianping.cat.alarm.spi.sender.SenderManager;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.alert.Action;
import com.dianping.cat.report.page.alert.Context;
import com.dianping.cat.report.page.alert.Handler;
import com.dianping.cat.report.page.alert.JspViewer;
import com.dianping.cat.report.page.alert.Model;
import com.dianping.cat.report.page.alert.Payload;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private SenderManager m_senderManager;
    @Inject
    private AlertDao m_alertDao;

    private Alert buildAlertEntity(Payload payload) {
        Alert alertEntity = new Alert();
        alertEntity.setAlertTime(payload.getAlertTime());
        alertEntity.setCategory(payload.getCategory());
        alertEntity.setContent(payload.getContent());
        alertEntity.setDomain(payload.getDomain());
        alertEntity.setMetric(payload.getMetric());
        alertEntity.setType(payload.getLevel());
        return alertEntity;
    }

    private Map<String, AlertMinute> generateAlertMinutes(List<Alert> alerts) {
        SimpleDateFormat format = new SimpleDateFormat("MM-dd HH:mm");
        LinkedHashMap<String, AlertMinute> alertMinutes = new LinkedHashMap<String, AlertMinute>();
        for (Alert alert : alerts) {
            String time = format.format(alert.getAlertTime());
            AlertMinute alertMinute = (AlertMinute)alertMinutes.get(time);
            if (alertMinute == null) {
                alertMinute = new AlertMinute(this, time);
                alertMinutes.put(time, alertMinute);
            }
            alertMinute.addAlert(alert);
        }
        return alertMinutes;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="alert")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="alert")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        switch (1.$SwitchMap$com$dianping$cat$report$page$alert$Action[action.ordinal()]) {
            case 1: {
                List receivers = Splitters.by((String)",").noEmptyItem().split(payload.getReceivers());
                if (receivers == null || receivers.size() == 0) {
                    this.setAlertResult(model, 0);
                    break;
                }
                SendMessageEntity message = new SendMessageEntity(payload.getGroup(), payload.getTitle(), payload.getType(), payload.getContent(), receivers);
                try {
                    boolean result = this.m_senderManager.sendAlert(AlertChannel.findByName((String)payload.getChannel()), message);
                    if (result) {
                        this.setAlertResult(model, 1);
                        break;
                    }
                    this.setAlertResult(model, 2);
                }
                catch (NullPointerException ex) {
                    this.setAlertResult(model, 3);
                }
                break;
            }
            case 2: {
                if (StringUtils.isEmpty((String)payload.getDomain())) {
                    this.setAlertResult(model, 4);
                    break;
                }
                Alert alertEntity = this.buildAlertEntity(payload);
                try {
                    int count = this.m_alertDao.insert(alertEntity);
                    if (count == 0) {
                        this.setAlertResult(model, 5);
                        break;
                    }
                    this.setAlertResult(model, 1);
                }
                catch (DalException e) {
                    this.setAlertResult(model, 5);
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 3: {
                List alerts;
                Date startTime = payload.getStartTime();
                Date endTime = payload.getEndTime();
                String domain = payload.getDomain();
                String alertTypeStr = payload.getAlertType();
                try {
                    alerts = StringUtils.isEmpty((String)alertTypeStr) ? this.m_alertDao.queryAlertsByTimeDomain(startTime, endTime, domain, AlertEntity.READSET_FULL) : this.m_alertDao.queryAlertsByTimeDomainCategories(startTime, endTime, domain, payload.getAlertTypeArray(), AlertEntity.READSET_FULL);
                }
                catch (DalException e) {
                    alerts = new ArrayList();
                    Cat.logError((Throwable)e);
                }
                model.setAlertMinutes(this.generateAlertMinutes(alerts));
            }
        }
        model.setAction((org.unidal.web.mvc.Action)action);
        model.setPage((Page)ReportPage.ALERT);
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    private void setAlertResult(Model model, int status) {
        switch (status) {
            case 0: {
                model.setAlertResult("{\"status\":500, \"errorMessage\":\"lack receivers\"}");
                break;
            }
            case 1: {
                model.setAlertResult("{\"status\":200}");
                break;
            }
            case 2: {
                model.setAlertResult("{\"status\":500, \"errorMessage\":\"send failed, please retry again\"}");
                break;
            }
            case 3: {
                model.setAlertResult("{\"status\":500, \"errorMessage\":\"send failed, please check your channel argument\"}");
                break;
            }
            case 4: {
                model.setAlertResult("{\"status\":500, \"errorMessage\":\"lack domain\"}");
                break;
            }
            case 5: {
                model.setAlertResult("{\"status\":500}");
            }
        }
    }
}

