/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business.graph;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.spi.AlertEntity;
import com.dianping.cat.config.business.BusinessConfigManager;
import com.dianping.cat.configuration.business.entity.BusinessItemConfig;
import com.dianping.cat.configuration.business.entity.BusinessReportConfig;
import com.dianping.cat.configuration.business.entity.CustomConfig;
import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.helper.MetricType;
import com.dianping.cat.home.business.entity.BusinessItem;
import com.dianping.cat.home.business.entity.Tag;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.metric.AbstractGraphCreator;
import com.dianping.cat.report.page.business.graph.BusinessDataFetcher;
import com.dianping.cat.report.page.business.graph.CustomDataCalculator;
import com.dianping.cat.report.page.business.graph.CustomInfo;
import com.dianping.cat.report.page.business.service.CachedBusinessReportService;
import com.dianping.cat.report.page.business.task.BusinessKeyHelper;
import com.dianping.cat.service.ProjectService;
import com.dianping.cat.system.page.business.config.BusinessTagConfigManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;

public class BusinessGraphCreator
extends AbstractGraphCreator {
    @Inject
    private CachedBusinessReportService m_reportService;
    @Inject
    private BusinessConfigManager m_configManager;
    @Inject
    private BusinessDataFetcher m_dataFetcher;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private BusinessTagConfigManager m_tagManager;
    @Inject
    private BusinessKeyHelper m_keyHelper;
    @Inject
    private CustomDataCalculator m_customDataCalculator;

    private Pair<String, Boolean> buidlTitleAndPrivilege(BusinessReportConfig businessReportConfig, String itemId, String type) {
        boolean isPrivilege = false;
        String title = null;
        String des = MetricType.getDesByName((String)type);
        BusinessItemConfig config = businessReportConfig.findBusinessItemConfig(itemId);
        if (config != null) {
            title = config.getTitle() + des;
            isPrivilege = config.isPrivilege();
        } else {
            CustomConfig customConfig = businessReportConfig.findCustomConfig(itemId);
            if (customConfig != null) {
                title = customConfig.getTitle() + des;
                isPrivilege = customConfig.isPrivilege();
            }
        }
        return new Pair((Object)title, (Object)isPrivilege);
    }

    private Map<String, LineChart> buildCharts(Map<String, double[]> datas, Map<String, double[]> baseLines, Date start, Date end, Map<String, BusinessReportConfig> configs) {
        Map allCurrentValues = this.m_dataExtractor.extract(datas);
        Map dataWithOutFutures = this.removeFutureData(end, allCurrentValues);
        LinkedHashMap<String, LineChart> charts = new LinkedHashMap<String, LineChart>();
        List alertKeys = this.m_alertManager.queryLastestAlarmKey(5);
        int step = this.m_dataExtractor.getStep();
        for (Map.Entry entry : dataWithOutFutures.entrySet()) {
            try {
                String key = (String)entry.getKey();
                double[] value = (double[])entry.getValue();
                String domain = this.m_keyHelper.getDomain(key);
                BusinessReportConfig config = configs.get(domain);
                LineChart lineChart = new LineChart();
                this.buildLineChartTitle(alertKeys, lineChart, key, config);
                lineChart.setStart(start);
                lineChart.setSize(value.length);
                lineChart.setStep((long)step * 60000L);
                double[] baselines = baseLines.get(key);
                Map all = this.convertToMap(datas.get(key), start, 1);
                Map current = this.convertToMap((double[])dataWithOutFutures.get(key), start, step);
                this.addLastMinuteData(current, all, this.m_lastMinute, end);
                lineChart.add("\u5f53\u524d\u503c", current);
                lineChart.add("\u57fa\u7ebf\u503c", this.convertToMap(this.m_dataExtractor.extract(baselines), start, step));
                charts.put(key, lineChart);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return charts;
    }

    protected String buildContactInfo(String domainName) {
        try {
            Project project = this.m_projectService.findByDomain(domainName);
            if (project != null) {
                String owners = project.getOwner();
                String phones = project.getPhone();
                StringBuilder builder = new StringBuilder();
                builder.append("[\u9879\u76ee: ").append(domainName);
                if (!StringUtils.isEmpty((String)owners)) {
                    builder.append(" \u8d1f\u8d23\u4eba: ").append(owners);
                }
                if (!StringUtils.isEmpty((String)phones)) {
                    builder.append(" \u624b\u673a: ").append(phones).append(" ]");
                }
                return builder.toString();
            }
        }
        catch (Exception ex) {
            Cat.logError((String)("build contact info error for doamin: " + domainName), (Throwable)ex);
        }
        return null;
    }

    public Map<String, LineChart> buildGraphByDomain(Date start, Date end, String domain) {
        BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
        LinkedHashMap<String, LineChart> result = new LinkedHashMap<String, LineChart>();
        if (config != null) {
            Map datas = this.prepareBusinessItemDatas(start, end, domain, config);
            Map baseLines = this.prepareBusinessItemBaseLines(start, end, datas.keySet());
            Map customConfigs = config.getCustomConfigs();
            Map customBaseLines = this.prepareCustomBaseLines(start, end, domain, customConfigs);
            Map customDatas = this.prepareCustomDatas(start, end, domain, customConfigs, datas);
            HashMap<String, BusinessReportConfig> configs = new HashMap<String, BusinessReportConfig>();
            configs.put(domain, config);
            result.putAll(this.buildCharts(datas, baseLines, start, end, configs));
            result.putAll(this.buildCharts(customDatas, customBaseLines, start, end, configs));
        }
        return result;
    }

    public Map<String, LineChart> buildGraphByTag(Date start, Date end, String tag) {
        Tag tagConfig = this.m_tagManager.findTag(tag);
        if (tagConfig != null) {
            String domain;
            List items = tagConfig.getBusinessItems();
            LinkedHashMap all = new LinkedHashMap();
            LinkedHashMap<String, double[]> needed = new LinkedHashMap<String, double[]>();
            HashMap<String, double[]> baseLines = new HashMap<String, double[]>();
            HashMap configs = new HashMap();
            HashMap customConfigs = new HashMap();
            HashMap businessItemConfigs = new HashMap();
            this.buildTagConfigs(items, configs, customConfigs, businessItemConfigs);
            for (Map.Entry businessItemConfigItem : businessItemConfigs.entrySet()) {
                domain = (String)businessItemConfigItem.getKey();
                BusinessReportConfig config = (BusinessReportConfig)configs.get(domain);
                Map datas = this.prepareBusinessItemDatas(start, end, domain, config);
                all.putAll(datas);
                for (String key : (Set)businessItemConfigItem.getValue()) {
                    for (MetricType metricType : MetricType.values()) {
                        String id = this.m_keyHelper.generateKey(key, domain, metricType.getName());
                        double[] baseline = this.queryBaseline("business", id, start, end);
                        baseLines.put(id, baseline);
                        double[] data = (double[])all.get(id);
                        if (data == null) continue;
                        needed.put(id, data);
                    }
                }
            }
            for (Map.Entry customConfigItem : customConfigs.entrySet()) {
                domain = (String)customConfigItem.getKey();
                Map value = (Map)customConfigItem.getValue();
                Map customDatas = this.prepareCustomDatas(start, end, domain, value, all);
                Map customBaseLines = this.prepareCustomBaseLines(start, end, domain, value);
                needed.putAll(customDatas);
                baseLines.putAll(customBaseLines);
            }
            return this.buildCharts(needed, baseLines, start, end, configs);
        }
        return new HashMap<String, LineChart>();
    }

    private void buildTagConfigs(List<BusinessItem> items, Map<String, BusinessReportConfig> configs, Map<String, Map<String, CustomConfig>> customConfigs, Map<String, Set<String>> businessItemConfigs) {
        for (BusinessItem item : items) {
            BusinessItemConfig businessItem;
            String domain = item.getDomain();
            String itemId = item.getItemId();
            BusinessReportConfig config = configs.get(domain);
            Map<String, CustomConfig> customConfig = customConfigs.get(domain);
            Set<String> businessItemConfig = businessItemConfigs.get(domain);
            if (config == null) {
                config = this.m_configManager.queryConfigByDomain(domain);
                if (config != null) {
                    configs.put(domain, config);
                }
                customConfig = new HashMap<String, CustomConfig>();
                businessItemConfig = new HashSet<String>();
                customConfigs.put(domain, customConfig);
                businessItemConfigs.put(domain, businessItemConfig);
            }
            if ((businessItem = config.findBusinessItemConfig(itemId)) == null) {
                CustomConfig customItem = config.findCustomConfig(itemId);
                if (customItem == null) continue;
                customConfig.put(itemId, customItem);
                continue;
            }
            businessItemConfig.add(itemId);
        }
    }

    private Map<String, double[]> buildGraphData(BusinessReport report, BusinessReportConfig config) {
        LinkedHashMap<String, double[]> values = new LinkedHashMap<String, double[]>();
        Map datas = this.m_dataFetcher.buildGraphData(report);
        Map businessItemConfigs = config.getBusinessItemConfigs();
        ArrayList items = new ArrayList(businessItemConfigs.values());
        Collections.sort(items, new /* Unavailable Anonymous Inner Class!! */);
        for (BusinessItemConfig itemConfig : items) {
            String key = itemConfig.getId();
            if (itemConfig.getShowAvg()) {
                String avgKey = this.m_keyHelper.generateKey(key, report.getDomain(), MetricType.AVG.name());
                this.putKey(datas, values, avgKey);
            }
            if (itemConfig.getShowCount()) {
                String countKey = this.m_keyHelper.generateKey(key, report.getDomain(), MetricType.COUNT.name());
                this.putKey(datas, values, countKey);
            }
            if (!itemConfig.getShowSum()) continue;
            String sumKey = this.m_keyHelper.generateKey(key, report.getDomain(), MetricType.SUM.name());
            this.putKey(datas, values, sumKey);
        }
        return values;
    }

    private void buildLineChartTitle(List<AlertEntity> alertKeys, LineChart chart, String key, BusinessReportConfig businessReportConfig) {
        String domain = businessReportConfig.getId();
        String itemId = this.m_keyHelper.getBusinessItemId(key);
        String type = this.m_keyHelper.getType(key);
        Pair titleAndPrivilege = this.buidlTitleAndPrivilege(businessReportConfig, itemId, type);
        String title = (String)titleAndPrivilege.getKey();
        chart.setTitle(title);
        chart.setId(key);
        if (((Boolean)titleAndPrivilege.getValue()).booleanValue()) {
            chart.setyEnabled(false);
        }
        if (this.containMetric(alertKeys, itemId, domain)) {
            String contactInfo = this.buildContactInfo(domain);
            chart.setHtmlTitle("<span style='color:red'>" + title + "<br><small>" + contactInfo + "</small></span>");
        } else {
            chart.setHtmlTitle(title);
        }
    }

    private boolean containMetric(List<AlertEntity> alertKeys, String metricId, String domain) {
        for (AlertEntity alertMetric : alertKeys) {
            if (!alertMetric.getDomain().equals(domain) || !alertMetric.getMetric().equals(metricId)) continue;
            return true;
        }
        return false;
    }

    private Map<String, double[]> prepareBusinessItemBaseLines(Date start, Date end, Set<String> keys) {
        HashMap<String, double[]> baselines = new HashMap<String, double[]>();
        for (String key : keys) {
            double[] baseline = this.queryBaseline("business", key, start, end);
            baselines.put(key, baseline);
        }
        return baselines;
    }

    private Map<String, double[]> prepareBusinessItemDatas(Date startDate, Date endDate, String domain, BusinessReportConfig config) {
        long start;
        long end = endDate.getTime();
        int totalSize = (int)((end - start) / 60000L);
        LinkedHashMap<String, double[]> oldCurrentValues = new LinkedHashMap<String, double[]>();
        int index = 0;
        for (start = startDate.getTime(); start < end; start += 3600000L) {
            BusinessReport report = this.m_reportService.queryBusinessReport(domain, new Date(start));
            Map currentValues = this.buildGraphData(report, config);
            this.mergeMap(oldCurrentValues, currentValues, totalSize, index);
            ++index;
        }
        return oldCurrentValues;
    }

    private Map<String, double[]> prepareCustomBaseLines(Date start, Date end, String currentDomain, Map<String, CustomConfig> customConfigs) {
        HashMap<String, double[]> baseLineCache = new HashMap<String, double[]>();
        LinkedHashMap<String, double[]> customBaseLines = new LinkedHashMap<String, double[]>();
        int totalSize = (int)((end.getTime() - start.getTime()) / 60000L);
        for (CustomConfig customConfig : customConfigs.values()) {
            try {
                String pattern = customConfig.getPattern();
                List customInfos = this.m_customDataCalculator.translatePattern(pattern);
                for (CustomInfo customInfo : customInfos) {
                    String customKey = this.m_keyHelper.generateKey(customInfo.getKey(), customInfo.getDomain(), customInfo.getType());
                    baseLineCache.put(customKey, this.queryBaseline("business", customKey, start, end));
                }
                double[] baseLine = this.m_customDataCalculator.calculate(pattern, customInfos, baseLineCache, totalSize);
                String key = this.m_keyHelper.generateKey(customConfig.getId(), currentDomain, MetricType.AVG.getName());
                customBaseLines.put(key, baseLine);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return customBaseLines;
    }

    private Map<String, double[]> prepareCustomDatas(Date start, Date end, String currentDomain, Map<String, CustomConfig> customConfigs, Map<String, double[]> datas) {
        LinkedHashMap<String, double[]> customDatas = new LinkedHashMap<String, double[]>();
        HashMap<String, double[]> businessItemDataCache = new HashMap<String, double[]>();
        HashSet<String> domains = new HashSet<String>();
        int totalSize = (int)((end.getTime() - start.getTime()) / 60000L);
        domains.add(currentDomain);
        businessItemDataCache.putAll(datas);
        for (CustomConfig customConfig : customConfigs.values()) {
            try {
                String pattern = customConfig.getPattern();
                List customInfos = this.m_customDataCalculator.translatePattern(pattern);
                for (CustomInfo customInfo : customInfos) {
                    String domain = customInfo.getDomain();
                    if (domains.contains(domain)) continue;
                    BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
                    domains.add(domain);
                    businessItemDataCache.putAll(this.prepareBusinessItemDatas(start, end, domain, config));
                }
                double[] data = this.m_customDataCalculator.calculate(pattern, customInfos, businessItemDataCache, totalSize);
                String key = this.m_keyHelper.generateKey(customConfig.getId(), currentDomain, MetricType.AVG.getName());
                customDatas.put(key, data);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return customDatas;
    }
}

