/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business.service;

import com.dianping.cat.consumer.business.BusinessReportMerger;
import com.dianping.cat.consumer.business.model.IEntity;
import com.dianping.cat.consumer.business.model.IVisitor;
import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.consumer.business.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.business.service.LocalBusinessService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=LocalModelService.class, value="business")
public class LocalBusinessService
extends LocalModelService<BusinessReport> {
    public static final String ID = "business";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalBusinessService() {
        super(ID);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        long startTime;
        List reports = super.getReport(period, domain);
        BusinessReport report = null;
        if (reports != null) {
            report = new BusinessReport(domain);
            BusinessReportMerger merger = new BusinessReportMerger(report);
            for (BusinessReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getBusinessItems().isEmpty()) && period.isLast() && (report = this.getReportFromLocalDisk(startTime = request.getStartTime(), domain)) == null) {
            report = new BusinessReport(domain);
            report.setStartTime(new Date(startTime));
            report.setEndTime(new Date(startTime + 3600000L - 1L));
        }
        BusinessReportFilter filter = new BusinessReportFilter(payload.getMin(), payload.getMax());
        return filter.buildXml((IEntity)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusinessReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        BusinessReport report = new BusinessReport(domain);
        BusinessReportMerger merger = new BusinessReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml == null) continue;
                BusinessReport tmp = DefaultSaxParser.parse((String)xml);
                tmp.accept((IVisitor)merger);
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

