/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business.task;

import com.dianping.cat.config.business.BusinessConfigManager;
import com.dianping.cat.configuration.business.entity.BusinessItemConfig;
import com.dianping.cat.configuration.business.entity.BusinessReportConfig;
import com.dianping.cat.consumer.business.model.entity.BusinessItem;
import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.helper.MetricType;
import com.dianping.cat.home.dal.report.Baseline;
import com.dianping.cat.report.page.business.service.BusinessReportService;
import com.dianping.cat.report.page.business.task.BusinessKeyHelper;
import com.dianping.cat.report.page.business.task.BusinessPointParser;
import com.dianping.cat.report.page.metric.service.BaselineService;
import com.dianping.cat.report.page.metric.task.BaselineConfig;
import com.dianping.cat.report.page.metric.task.BaselineConfigManager;
import com.dianping.cat.report.page.metric.task.BaselineCreator;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="business")
public class BusinessBaselineReportBuilder
implements TaskBuilder {
    public static final String ID = "business";
    private static final int POINT_NUMBER = 1440;
    @Inject
    private BusinessReportService m_reportService;
    @Inject
    private BusinessConfigManager m_configManager;
    @Inject
    private BaselineConfigManager m_baselineConfigManager;
    @Inject
    private BusinessPointParser m_parser;
    @Inject
    private BaselineCreator m_baselineCreator;
    @Inject
    private BaselineService m_baselineService;
    @Inject
    private BusinessKeyHelper m_keyHelper;

    public boolean buildDailyTask(String name, String domain, Date period) {
        HashMap reports = new HashMap();
        BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
        Map itemConfigs = config.getBusinessItemConfigs();
        BaselineConfig baselineConfig = this.m_baselineConfigManager.queryBaseLineConfig(domain);
        List days = baselineConfig.getDays();
        Date targetDate = new Date(period.getTime() + (long)baselineConfig.getTargetDate() * 86400000L);
        for (BusinessItemConfig itemConfig : itemConfigs.values()) {
            String itemId = itemConfig.getId();
            for (MetricType type : MetricType.values()) {
                ArrayList<double[]> values = new ArrayList<double[]>();
                for (Integer day : days) {
                    Date date = new Date(period.getTime() + (long)day.intValue() * 86400000L);
                    List businessItems = this.buildOneDayBusinessItems(domain, itemId, date, reports);
                    double[] oneDayValue = this.m_parser.buildDailyData(businessItems, type);
                    values.add(oneDayValue);
                }
                String key = this.m_keyHelper.generateKey(itemId, domain, type.getName());
                double[] result = this.m_baselineCreator.createBaseLine(values, baselineConfig.getWeights(), 1440);
                this.storeBaseLine(name, key, targetDate, result);
                Date tomorrow = new Date(period.getTime() + 86400000L);
                boolean exist = this.m_baselineService.hasDailyBaseline(name, key, tomorrow);
                if (exist) continue;
                this.storeBaseLine(name, key, tomorrow, result);
            }
        }
        return true;
    }

    private List<BusinessItem> buildOneDayBusinessItems(String domain, String itemId, Date date, Map<String, BusinessReport> reports) {
        ArrayList<BusinessItem> items = new ArrayList<BusinessItem>();
        for (int i = 0; i < 24; ++i) {
            BusinessItem item;
            Date start = new Date(date.getTime() + (long)i * 3600000L);
            Date end = new Date(start.getTime() + 3600000L);
            String reportKey = itemId + start.getTime();
            BusinessReport report = reports.get(reportKey);
            if (report == null) {
                report = (BusinessReport)this.m_reportService.queryReport(domain, start, end);
                reports.put(reportKey, report);
            }
            if ((item = report.findBusinessItem(itemId)) == null) {
                item = new BusinessItem(itemId);
            }
            items.add(item);
        }
        return items;
    }

    private void storeBaseLine(String name, String key, Date targetDate, double[] result) {
        Baseline baseline = new Baseline();
        baseline.setDataInDoubleArray(result);
        baseline.setIndexKey(key);
        baseline.setReportName(name);
        baseline.setReportPeriod(targetDate);
        this.m_baselineService.insertBaseline(baseline);
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("Business base line report don't support hourly report!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("Business base line report don't support monthly report!");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("Business base line report don't support weekly report!");
    }
}

