/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business.task;

import com.dianping.cat.consumer.business.model.entity.BusinessItem;
import com.dianping.cat.consumer.business.model.entity.Segment;
import com.dianping.cat.helper.MetricType;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Named;

@Named
public class BusinessPointParser {
    private static final int POINT_NUMBER = 60;

    public double[] buildDailyData(List<BusinessItem> items, MetricType type) {
        int size = items.size();
        double[] values = new double[1440];
        for (int i = 0; i < 1440; ++i) {
            values[i] = -1.0;
        }
        for (int hour = 0; hour < size; ++hour) {
            BusinessItem item = items.get(hour);
            try {
                double[] oneHourValues = this.buildHourlyData(item, type);
                for (int minute = 0; minute < 60; ++minute) {
                    int index = hour * 60 + minute;
                    values[index] = oneHourValues[minute];
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return values;
    }

    private double[] buildHourlyData(BusinessItem item, MetricType type) {
        double[] result = new double[60];
        Map map = item.getSegments();
        for (Map.Entry entry : map.entrySet()) {
            Integer minute = (Integer)entry.getKey();
            Segment seg = (Segment)entry.getValue();
            if (type == MetricType.AVG) {
                result[minute.intValue()] = seg.getAvg();
                continue;
            }
            if (type == MetricType.COUNT) {
                result[minute.intValue()] = seg.getCount();
                continue;
            }
            if (type != MetricType.SUM) continue;
            result[minute.intValue()] = seg.getSum();
        }
        return result;
    }
}

