/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross;

import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.cross.Action;
import com.dianping.cat.report.page.cross.Context;
import com.dianping.cat.report.page.cross.CrossMethodVisitor;
import com.dianping.cat.report.page.cross.Handler;
import com.dianping.cat.report.page.cross.JspViewer;
import com.dianping.cat.report.page.cross.Model;
import com.dianping.cat.report.page.cross.Payload;
import com.dianping.cat.report.page.cross.display.HostInfo;
import com.dianping.cat.report.page.cross.display.MethodInfo;
import com.dianping.cat.report.page.cross.display.ProjectInfo;
import com.dianping.cat.report.page.cross.service.CrossReportService;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.service.HostinfoService;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private CrossReportService m_reportService;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private HostinfoService m_hostinfoService;
    @Inject(type=ModelService.class, value={"cross"})
    private ModelService<CrossReport> m_service;

    private CrossReport getHourlyReport(Payload payload) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("ip", ipAddress);
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            CrossReport report = (CrossReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligable cross service registered for " + request + "!");
    }

    private CrossReport getSummarizeReport(Payload payload) {
        String domain = payload.getDomain();
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        return (CrossReport)this.m_reportService.queryReport(domain, start, end);
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="cross")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="cross")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.normalize(model, payload);
        long historyTime = (payload.getHistoryEndDate().getTime() - payload.getHistoryStartDate().getTime()) / 1000L;
        switch (1.$SwitchMap$com$dianping$cat$report$page$cross$Action[payload.getAction().ordinal()]) {
            case 1: {
                CrossReport projectReport = this.getHourlyReport(payload);
                ProjectInfo projectInfo = new ProjectInfo(payload.getHourDuration());
                projectInfo.setClientIp(model.getIpAddress()).setCallSortBy(model.getCallSort()).setServiceSortBy(model.getServiceSort());
                projectInfo.visitCrossReport(projectReport);
                model.setProjectInfo(projectInfo);
                model.setReport(projectReport);
                break;
            }
            case 2: {
                CrossReport hostReport = this.getHourlyReport(payload);
                HostInfo hostInfo = new HostInfo(payload.getHourDuration());
                hostInfo.setHostinfoService(this.m_hostinfoService);
                hostInfo.setClientIp(model.getIpAddress()).setCallSortBy(model.getCallSort()).setServiceSortBy(model.getServiceSort());
                hostInfo.setProjectName(payload.getProjectName());
                hostInfo.visitCrossReport(hostReport);
                model.setReport(hostReport);
                model.setHostInfo(hostInfo);
                break;
            }
            case 3: {
                CrossReport methodReport = this.getHourlyReport(payload);
                MethodInfo methodInfo = new MethodInfo(payload.getHourDuration());
                methodInfo.setHostinfoService(this.m_hostinfoService);
                methodInfo.setClientIp(model.getIpAddress()).setCallSortBy(model.getCallSort()).setServiceSortBy(model.getServiceSort()).setRemoteProject(payload.getProjectName());
                methodInfo.setRemoteIp(payload.getRemoteIp()).setQuery(model.getQueryName());
                methodInfo.visitCrossReport(methodReport);
                model.setReport(methodReport);
                model.setMethodInfo(methodInfo);
                break;
            }
            case 4: {
                CrossReport historyProjectReport = this.getSummarizeReport(payload);
                ProjectInfo historyProjectInfo = new ProjectInfo(historyTime);
                historyProjectInfo.setClientIp(model.getIpAddress()).setCallSortBy(model.getCallSort()).setServiceSortBy(model.getServiceSort());
                historyProjectInfo.visitCrossReport(historyProjectReport);
                model.setProjectInfo(historyProjectInfo);
                model.setReport(historyProjectReport);
                break;
            }
            case 5: {
                CrossReport historyHostReport = this.getSummarizeReport(payload);
                HostInfo historyHostInfo = new HostInfo(historyTime);
                historyHostInfo.setHostinfoService(this.m_hostinfoService);
                historyHostInfo.setClientIp(model.getIpAddress()).setCallSortBy(model.getCallSort()).setServiceSortBy(model.getServiceSort());
                historyHostInfo.setProjectName(payload.getProjectName());
                historyHostInfo.visitCrossReport(historyHostReport);
                model.setReport(historyHostReport);
                model.setHostInfo(historyHostInfo);
                break;
            }
            case 6: {
                CrossReport historyMethodReport = this.getSummarizeReport(payload);
                MethodInfo historyMethodInfo = new MethodInfo(historyTime);
                historyMethodInfo.setHostinfoService(this.m_hostinfoService);
                historyMethodInfo.setClientIp(model.getIpAddress()).setCallSortBy(model.getCallSort()).setServiceSortBy(model.getServiceSort()).setRemoteProject(payload.getProjectName());
                historyMethodInfo.setRemoteIp(payload.getRemoteIp()).setQuery(model.getQueryName());
                historyMethodInfo.visitCrossReport(historyMethodReport);
                model.setReport(historyMethodReport);
                model.setMethodInfo(historyMethodInfo);
                break;
            }
            case 7: {
                String method = payload.getMethod();
                CrossMethodVisitor info = new CrossMethodVisitor(method);
                CrossReport queryReport = null;
                queryReport = this.isHistory(payload) ? this.getSummarizeReport(payload) : this.getHourlyReport(payload);
                info.visitCrossReport(queryReport);
                model.setReport(queryReport);
                model.setInfo(info.getInfo());
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private boolean isHistory(Payload payload) {
        String rawDate = payload.getRawDate();
        return rawDate != null && rawDate.length() == 8;
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.CROSS);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        model.setCallSort(payload.getCallSort());
        model.setServiceSort(payload.getServiceSort());
        model.setQueryName(payload.getQueryName());
        if (StringUtils.isEmpty((String)payload.getProjectName())) {
            if (payload.getAction() == Action.HOURLY_HOST) {
                payload.setAction("view");
            }
            if (payload.getAction() == Action.HISTORY_HOST) {
                payload.setAction("history");
            }
        }
        if (StringUtils.isEmpty((String)payload.getRemoteIp())) {
            if (payload.getAction() == Action.HOURLY_METHOD) {
                payload.setAction("view");
            }
            if (payload.getAction() == Action.HISTORY_METHOD) {
                payload.setAction("history");
            }
        }
    }
}

