/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.cross.CrossReportMerger;
import com.dianping.cat.consumer.cross.model.IVisitor;
import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.consumer.cross.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.report.page.cross.service.CrossReportService;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import com.dianping.cat.report.task.current.CurrentWeeklyMonthlyReportTask;
import java.util.Date;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="cross")
public class CrossReportBuilder
implements TaskBuilder,
Initializable {
    public static final String ID = "cross";
    @Inject
    protected CrossReportService m_reportService;

    public boolean buildDailyTask(String name, String domain, Date period) {
        CrossReport crossReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((CrossReport)crossReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("Cross report don't support HourlyReport!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        CrossReport crossReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((CrossReport)crossReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        CrossReport crossReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((CrossReport)crossReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    public void initialize() throws InitializationException {
        CurrentWeeklyMonthlyReportTask.getInstance().register((CurrentWeeklyMonthlyReportTask.CurrentWeeklyMonthlyTask)new /* Unavailable Anonymous Inner Class!! */);
    }

    private CrossReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        CrossReportMerger merger = new CrossReportMerger(new CrossReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                CrossReport reportModel = (CrossReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        CrossReport crossReport = merger.getCrossReport();
        crossReport.setStartTime(start);
        crossReport.setEndTime(end);
        return crossReport;
    }

    private CrossReport queryHourlyReportsByDuration(String name, String domain, Date period, Date endDate) {
        long endTime = endDate.getTime();
        CrossReportMerger merger = new CrossReportMerger(new CrossReport(domain));
        for (long startTime = period.getTime(); startTime < endTime; startTime += 3600000L) {
            Date date = new Date(startTime);
            CrossReport reportModel = (CrossReport)this.m_reportService.queryReport(domain, date, new Date(date.getTime() + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        CrossReport crossReport = merger.getCrossReport();
        crossReport.setStartTime(period);
        crossReport.setEndTime(endDate);
        return crossReport;
    }
}

