/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency;

import com.dianping.cat.consumer.dependency.DependencyReportMerger;
import com.dianping.cat.consumer.dependency.model.entity.Dependency;
import com.dianping.cat.consumer.dependency.model.entity.DependencyReport;
import com.dianping.cat.consumer.dependency.model.entity.Index;
import com.dianping.cat.consumer.dependency.model.entity.Segment;
import com.dianping.cat.home.dependency.graph.IEntity;
import com.dianping.cat.home.dependency.graph.entity.TopologyGraph;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import com.dianping.cat.home.dependency.graph.transform.DefaultJsonBuilder;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.dependency.Action;
import com.dianping.cat.report.page.dependency.Context;
import com.dianping.cat.report.page.dependency.ExternalInfoBuilder;
import com.dianping.cat.report.page.dependency.Handler;
import com.dianping.cat.report.page.dependency.JspViewer;
import com.dianping.cat.report.page.dependency.Model;
import com.dianping.cat.report.page.dependency.Payload;
import com.dianping.cat.report.page.dependency.config.TopoGraphFormatConfigManager;
import com.dianping.cat.report.page.dependency.graph.LineGraphBuilder;
import com.dianping.cat.report.page.dependency.graph.ProductLinesDashboard;
import com.dianping.cat.report.page.dependency.graph.TopologyGraphManager;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    public static final List<String> NORMAL_URLS = Arrays.asList("/cat/r", "/cat/r/", "/cat/r/dependency");
    @Inject(type=ModelService.class, value={"dependency"})
    private ModelService<DependencyReport> m_dependencyService;
    @Inject
    private TopologyGraphManager m_graphManager;
    @Inject
    private ExternalInfoBuilder m_externalInfoBuilder;
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private TopoGraphFormatConfigManager m_formatConfigManager;

    private Segment buildAllSegmentsInfo(DependencyReport report) {
        Segment result = new Segment();
        Map segments = report.getSegments();
        DependencyReportMerger merger = new DependencyReportMerger(null);
        for (Segment segment : segments.values()) {
            Index temp;
            Map dependencies = segment.getDependencies();
            Map indexs = segment.getIndexs();
            for (Index index : indexs.values()) {
                temp = result.findOrCreateIndex(index.getName());
                merger.mergeIndex(temp, index);
            }
            for (Dependency dependency : dependencies.values()) {
                temp = result.findOrCreateDependency(dependency.getKey());
                merger.mergeDependency((Dependency)temp, dependency);
            }
        }
        return result;
    }

    private void buildDependencyDashboard(Model model, Payload payload, Date reportTime) {
        ProductLinesDashboard dashboardGraph = this.m_graphManager.buildDependencyDashboard(reportTime.getTime());
        Map nodes = dashboardGraph.getNodes();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
        String minute = String.valueOf(this.parseQueryMinute(payload));
        for (List n : nodes.values()) {
            for (TopologyNode node : n) {
                String domain = node.getId();
                String link = String.format("?op=dependencyGraph&minute=%s&domain=%s&date=%s", minute, domain, sdf.format(new Date(payload.getDate())));
                node.setLink(link);
            }
        }
        model.setReportStart(new Date(payload.getDate()));
        model.setReportEnd(new Date(payload.getDate() + 3600000L - 1L));
        model.setDashboardGraph(dashboardGraph.toJson());
        model.setDashboardGraphData(dashboardGraph);
        model.setFormat(this.m_formatConfigManager.buildFormatJson());
    }

    private void buildDependencyLineChart(Model model, Payload payload, Date reportTime) {
        DependencyReport dependencyReport = this.queryDependencyReport(payload);
        this.buildHourlyReport(dependencyReport, model, payload);
        this.buildHourlyLineGraph(dependencyReport, model);
    }

    private void buildHourlyLineGraph(DependencyReport report, Model model) {
        LineGraphBuilder builder = new LineGraphBuilder();
        builder.visitDependencyReport(report);
        List index = builder.queryIndex();
        Map dependencys = builder.queryDependencyGraph();
        model.setIndexGraph(this.buildLineChartGraph(index));
        model.setDependencyGraph(this.buildLineChartGraphs(dependencys));
    }

    private void buildHourlyReport(DependencyReport report, Model model, Payload payload) {
        Segment segment = report.findSegment(Integer.valueOf(model.getMinute()));
        model.setReport(report);
        model.setSegment(segment);
        if (payload.isAll()) {
            model.setSegment(this.buildAllSegmentsInfo(report));
        }
    }

    private List<String> buildLineChartGraph(List<LineChart> charts) {
        ArrayList<String> result = new ArrayList<String>();
        for (LineChart temp : charts) {
            result.add(temp.getJsonString());
        }
        return result;
    }

    private Map<String, List<String>> buildLineChartGraphs(Map<String, List<LineChart>> charts) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<LineChart>> temp : charts.entrySet()) {
            result.put(temp.getKey(), this.buildLineChartGraph(temp.getValue()));
        }
        return result;
    }

    private void buildProjectTopology(Model model, Payload payload, Date reportTime) {
        TopologyGraph topologyGraph = this.m_graphManager.buildTopologyGraph(model.getDomain(), reportTime.getTime());
        DependencyReport report = this.queryDependencyReport(payload);
        this.buildHourlyReport(report, model, payload);
        this.m_externalInfoBuilder.buildExceptionInfoOnGraph(payload, model, topologyGraph);
        model.setReportStart(new Date(payload.getDate()));
        model.setReportEnd(new Date(payload.getDate() + 3600000L - 1L));
        String build = new DefaultJsonBuilder().build((IEntity)topologyGraph);
        model.setTopologyGraph(build);
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="dependency")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="dependency")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        if (this.validate(ctx)) {
            Model model = new Model(ctx);
            Payload payload = (Payload)ctx.getPayload();
            this.normalize(model, payload);
            Action action = payload.getAction();
            long date = payload.getDate();
            Date reportTime = new Date(date + 60000L * (long)model.getMinute());
            switch (1.$SwitchMap$com$dianping$cat$report$page$dependency$Action[action.ordinal()]) {
                case 1: {
                    this.buildDependencyLineChart(model, payload, reportTime);
                    break;
                }
                case 2: {
                    this.buildProjectTopology(model, payload, reportTime);
                    break;
                }
                case 3: {
                    this.buildDependencyDashboard(model, payload, reportTime);
                }
            }
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.DEPENDENCY);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        int minute = this.parseQueryMinute(payload);
        int maxMinute = 60;
        ArrayList<Integer> minutes = new ArrayList<Integer>();
        if (payload.getPeriod().isCurrent()) {
            long current = payload.getCurrentTimeMillis() / 1000L / 60L;
            maxMinute = (int)(current % 60L);
        }
        for (int i = 0; i < 60; ++i) {
            minutes.add(i);
        }
        model.setMinute(minute);
        model.setMaxMinute(maxMinute);
        model.setMinutes(minutes);
    }

    private int parseQueryMinute(Payload payload) {
        int minute = 0;
        String min = payload.getMinute();
        if (StringUtils.isEmpty((String)min)) {
            long current = payload.getCurrentTimeMillis() / 1000L / 60L;
            minute = (int)(current % 60L);
        } else {
            minute = Integer.parseInt(min);
        }
        return minute;
    }

    private DependencyReport queryDependencyReport(Payload payload) {
        String domain = payload.getDomain();
        ModelRequest request = new ModelRequest(domain, payload.getDate());
        if (this.m_dependencyService.isEligable(request)) {
            ModelResponse response = this.m_dependencyService.invoke(request);
            DependencyReport report = (DependencyReport)response.getModel();
            if (report != null && report.getStartTime() == null) {
                report.setStartTime(new Date(payload.getDate()));
                report.setStartTime(new Date(payload.getDate() + 3600000L));
            }
            return report;
        }
        throw new RuntimeException("Internal error: no eligable dependency service registered for " + request + "!");
    }

    private boolean validate(Context ctx) {
        String url = ctx.getRequestContext().getActionUri();
        String actionUrl = url.split("\\?")[0];
        return NORMAL_URLS.contains(actionUrl);
    }
}

