/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.home.dependency.format.entity.ProductLine;
import com.dianping.cat.home.dependency.format.entity.TopoGraphFormatConfig;
import com.dianping.cat.home.dependency.format.transform.DefaultSaxParser;
import java.util.HashMap;
import java.util.List;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class TopoGraphFormatConfigManager
implements Initializable {
    private static final String CONFIG_NAME = "topoGraphFormat";
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private TopoGraphFormatConfig m_config;

    public String buildFormatJson() {
        HashMap map = new HashMap();
        for (ProductLine productline : this.m_config.getProductLines()) {
            HashMap<String, Integer> p = new HashMap<String, Integer>();
            map.put(productline.getId(), p);
            p.put("colInside", productline.getColInside());
        }
        return new JsonBuilder().toJson(map);
    }

    public TopoGraphFormatConfig getConfig() {
        return this.m_config;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new TopoGraphFormatConfig();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public List<ProductLine> queryProduct() {
        return this.m_config.getProductLines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        TopoGraphFormatConfigManager topoGraphFormatConfigManager = this;
        synchronized (topoGraphFormatConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

