/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.graph;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.consumer.dependency.model.entity.Dependency;
import com.dianping.cat.consumer.dependency.model.entity.Index;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.dependency.config.entity.DomainConfig;
import com.dianping.cat.home.dependency.config.entity.EdgeConfig;
import com.dianping.cat.home.dependency.config.entity.NodeConfig;
import com.dianping.cat.home.dependency.config.entity.TopologyGraphConfig;
import com.dianping.cat.home.dependency.config.transform.DefaultSaxParser;
import com.dianping.cat.report.page.dependency.graph.GraphConstrant;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Files;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.tuple.Pair;

@Named
public class TopologyGraphConfigManager
implements Initializable {
    private static final String AVG_STR = "\u54cd\u5e94\u65f6\u95f4";
    private static final String ERROR_STR = "\u9519\u8bef\u6570";
    private static final String TOTAL_STR = "\u8bbf\u95ee\u91cf";
    private static final String MILLISECOND = "(ms)";
    private static final int OK = GraphConstrant.OK;
    private static final int WARN = GraphConstrant.WARN;
    private static final int ERROR = GraphConstrant.ERROR;
    private static final String CONFIG_NAME = "topologyConfig";
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private TopologyGraphConfig m_config;
    private DecimalFormat m_df = new DecimalFormat("0.0");
    private int m_configId;
    private String m_fileName;
    private Set<String> m_pigeonCalls = new HashSet<String>(Arrays.asList("Call", "PigeonCall", "PigeonClient"));
    private Set<String> m_pigeonServices = new HashSet<String>(Arrays.asList("Service", "PigeonService", "PigeonServer"));

    private String buildDes(String ... args) {
        StringBuilder sb = new StringBuilder();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            sb.append(args[i]).append(" ");
        }
        return sb.toString();
    }

    public Pair<Integer, String> buildEdgeState(String domain, Dependency dependency) {
        String type = this.formatType(dependency.getType());
        String from = domain;
        String to = dependency.getTarget();
        EdgeConfig config = this.queryEdgeConfig(type, from, to);
        long error = dependency.getErrorCount();
        StringBuilder sb = new StringBuilder();
        int errorCode = OK;
        if (config != null) {
            double avg = dependency.getAvg();
            long totalCount = dependency.getTotalCount();
            int minCount = config.getMinCountThreshold();
            sb.append(this.buildDes(new String[]{type, TOTAL_STR, String.valueOf(dependency.getTotalCount())})).append("<br/>");
            if (avg >= config.getErrorResponseTime() && totalCount > (long)minCount) {
                errorCode = ERROR;
                sb.append(this.buildErrorDes(new String[]{type, AVG_STR, this.m_df.format(avg), MILLISECOND})).append("<br/>");
            } else if (avg >= config.getWarningResponseTime() && totalCount > (long)minCount) {
                errorCode = WARN;
                sb.append(this.buildWarningDes(new String[]{type, AVG_STR, this.m_df.format(avg), MILLISECOND})).append("<br/>");
            } else {
                sb.append(this.buildDes(new String[]{type, AVG_STR, this.m_df.format(avg), MILLISECOND})).append("<br/>");
            }
            if (error >= (long)config.getErrorThreshold() && totalCount > (long)minCount) {
                errorCode = ERROR;
                sb.append(this.buildErrorDes(new String[]{type, ERROR_STR, String.valueOf(error)})).append("<br/>");
            } else if (error >= (long)config.getWarningThreshold() && totalCount > (long)minCount) {
                errorCode = WARN;
                sb.append(this.buildWarningDes(new String[]{type, ERROR_STR, String.valueOf(error)})).append("<br/>");
            } else if (error > 0L) {
                sb.append(this.buildDes(new String[]{type, ERROR_STR, String.valueOf(error)})).append("<br/>");
            }
        }
        Pair result = new Pair();
        result.setKey((Object)errorCode);
        result.setValue((Object)sb.toString());
        return result;
    }

    private String buildErrorDes(String ... args) {
        StringBuilder sb = new StringBuilder("<span style='color:red'>");
        String content = this.buildDes(args);
        sb.append(content).append("</span>");
        return sb.toString();
    }

    public Pair<Integer, String> buildNodeState(String domain, Index index) {
        String type = index.getName();
        String realType = this.formatType(type);
        DomainConfig config = this.queryNodeConfig(realType, domain);
        int errorCode = OK;
        StringBuilder sb = new StringBuilder();
        if (config != null) {
            double avg = index.getAvg();
            long error = index.getErrorCount();
            long totalCount = index.getTotalCount();
            int minCount = config.getMinCountThreshold();
            sb.append(type).append(" ");
            if (index.getTotalCount() > 0L && !type.equalsIgnoreCase("Exception")) {
                sb.append(this.buildDes(new String[]{TOTAL_STR, String.valueOf(index.getTotalCount())}));
            }
            if (avg >= config.getErrorResponseTime() && totalCount > (long)minCount) {
                errorCode = ERROR;
                sb.append(this.buildErrorDes(new String[]{AVG_STR, this.m_df.format(avg), MILLISECOND}));
            } else if (avg >= config.getWarningResponseTime() && totalCount > (long)minCount) {
                errorCode = WARN;
                sb.append(this.buildWarningDes(new String[]{AVG_STR, this.m_df.format(avg), MILLISECOND}));
            } else if (!type.equalsIgnoreCase("Exception")) {
                sb.append(this.buildDes(new String[]{AVG_STR, this.m_df.format(avg), MILLISECOND}));
            }
            if (error >= (long)config.getErrorThreshold() && totalCount > (long)minCount) {
                errorCode = ERROR;
                sb.append(this.buildErrorDes(new String[]{ERROR_STR, String.valueOf(error)}));
            } else if (error >= (long)config.getWarningThreshold() && totalCount > (long)minCount) {
                errorCode = WARN;
                sb.append(this.buildWarningDes(new String[]{ERROR_STR, String.valueOf(error)}));
            } else if (error > 0L) {
                sb.append(this.buildDes(new String[]{ERROR_STR, String.valueOf(error)}));
            }
            sb.append("<br/>");
        }
        Pair result = new Pair();
        result.setKey((Object)errorCode);
        result.setValue((Object)sb.toString());
        return result;
    }

    private String buildWarningDes(String ... args) {
        StringBuilder sb = new StringBuilder("<span style='color:#bfa22f'>");
        String content = this.buildDes(args);
        sb.append(content).append("</span>");
        return sb.toString();
    }

    private EdgeConfig convertNodeConfig(DomainConfig config) {
        EdgeConfig edgeConfig = new EdgeConfig();
        edgeConfig.setMinCountThreshold(config.getMinCountThreshold());
        edgeConfig.setWarningResponseTime(config.getWarningResponseTime());
        edgeConfig.setErrorResponseTime(config.getErrorResponseTime());
        edgeConfig.setWarningThreshold(config.getWarningThreshold());
        edgeConfig.setErrorThreshold(config.getErrorThreshold());
        return edgeConfig;
    }

    public boolean deleteDomainConfig(String type, String domain) {
        NodeConfig types = (NodeConfig)this.m_config.getNodeConfigs().get(type);
        types.removeDomainConfig(domain);
        return this.storeConfig();
    }

    public boolean deleteEdgeConfig(String type, String from, String to) {
        String key = type + ':' + from + ':' + to;
        this.m_config.removeEdgeConfig(key);
        return this.storeConfig();
    }

    private String formatType(String type) {
        String realType = type;
        if (type.startsWith("Cache.")) {
            realType = "Cache";
        } else if (this.m_pigeonCalls.contains(type)) {
            realType = "PigeonCall";
        } else if (this.m_pigeonServices.contains(type)) {
            realType = "PigeonService";
        }
        return realType;
    }

    public synchronized TopologyGraphConfig getConfig() {
        return this.m_config;
    }

    public void initialize() throws InitializationException {
        if (this.m_fileName != null) {
            try {
                String content = Files.forIO().readFrom(new File(this.m_fileName), "utf-8");
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        } else {
            try {
                Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
                String content = config.getContent();
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (DalNotFoundException e) {
                try {
                    String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                    Config config = this.m_configDao.createLocal();
                    config.setName(CONFIG_NAME);
                    config.setContent(content);
                    this.m_configDao.insert(config);
                    this.m_configId = config.getId();
                    this.m_config = DefaultSaxParser.parse((String)content);
                }
                catch (Exception ex) {
                    Cat.logError((Throwable)ex);
                }
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
            if (this.m_config == null) {
                this.m_config = new TopologyGraphConfig();
            }
        }
    }

    public boolean insertDomainConfig(String type, DomainConfig config) {
        this.m_config.findOrCreateNodeConfig(type).addDomainConfig(config);
        return this.storeConfig();
    }

    public boolean insertDomainDefaultConfig(String type, DomainConfig config) {
        NodeConfig node = this.m_config.findOrCreateNodeConfig(type);
        node.setDefaultMinCountThreshold(config.getMinCountThreshold());
        node.setDefaultErrorResponseTime(Double.valueOf(config.getErrorResponseTime()));
        node.setDefaultErrorThreshold(Integer.valueOf(config.getErrorThreshold()));
        node.setDefaultWarningResponseTime(Double.valueOf(config.getWarningResponseTime()));
        node.setDefaultWarningThreshold(Integer.valueOf(config.getWarningThreshold()));
        return this.storeConfig();
    }

    public boolean insertEdgeConfig(EdgeConfig config) {
        config.setKey(config.getType() + ":" + config.getFrom() + ":" + config.getTo());
        this.m_config.addEdgeConfig(config);
        return this.storeConfig();
    }

    public EdgeConfig queryEdgeConfig(String type, String from, String to) {
        EdgeConfig edgeConfig = this.m_config.findEdgeConfig(type + ":" + from + ":" + to);
        if (edgeConfig == null) {
            DomainConfig domainConfig = null;
            domainConfig = "PigeonCall".equalsIgnoreCase(type) ? this.queryNodeConfig("PigeonService", to) : ("PigeonServer".equalsIgnoreCase(type) ? this.queryNodeConfig("PigeonService", from) : this.queryNodeConfig(type, to));
            if (domainConfig != null) {
                edgeConfig = this.convertNodeConfig(domainConfig);
            }
        }
        return edgeConfig;
    }

    public DomainConfig queryNodeConfig(String type, String domain) {
        NodeConfig typesConfig = this.m_config.findNodeConfig(type);
        if (typesConfig != null) {
            DomainConfig config = typesConfig.findDomainConfig(domain);
            if (config == null) {
                config = new DomainConfig();
                config.setId(domain);
                config.setMinCountThreshold(typesConfig.getDefaultMinCountThreshold());
                config.setErrorResponseTime(typesConfig.getDefaultErrorResponseTime().doubleValue());
                config.setErrorThreshold(typesConfig.getDefaultErrorThreshold().intValue());
                config.setWarningResponseTime(typesConfig.getDefaultWarningResponseTime().doubleValue());
                config.setWarningThreshold(typesConfig.getDefaultWarningThreshold().intValue());
            }
            return config;
        }
        return null;
    }

    public void setFileName(String file) {
        this.m_fileName = file;
    }

    private boolean storeConfig() {
        if (this.m_fileName != null) {
            try {
                Files.forIO().writeTo(new File(this.m_fileName), this.m_config.toString());
            }
            catch (IOException e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        try {
            Config config = this.m_configDao.createLocal();
            config.setId(this.m_configId);
            config.setKeyId(this.m_configId);
            config.setName(CONFIG_NAME);
            config.setContent(this.m_config.toString());
            this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }
}

