/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.graph;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.consumer.dependency.model.entity.DependencyReport;
import com.dianping.cat.home.dal.report.TopologyGraph;
import com.dianping.cat.home.dal.report.TopologyGraphDao;
import com.dianping.cat.home.dal.report.TopologyGraphEntity;
import com.dianping.cat.home.dependency.format.entity.Domain;
import com.dianping.cat.home.dependency.format.entity.ProductLine;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import com.dianping.cat.home.dependency.graph.transform.DefaultNativeParser;
import com.dianping.cat.report.page.dependency.config.TopoGraphFormatConfigManager;
import com.dianping.cat.report.page.dependency.graph.DependencyItemBuilder;
import com.dianping.cat.report.page.dependency.graph.GraphConstrant;
import com.dianping.cat.report.page.dependency.graph.ProductLinesDashboard;
import com.dianping.cat.report.page.dependency.graph.TopologyGraphBuilder;
import com.dianping.cat.report.page.dependency.graph.TopologyGraphManager;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.service.ProjectService;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class TopologyGraphManager
implements Initializable,
LogEnabled {
    @Inject(type=ModelService.class, value={"dependency"})
    private ModelService<DependencyReport> m_service;
    @Inject
    private DependencyItemBuilder m_itemBuilder;
    @Inject
    private TopoGraphFormatConfigManager m_configManager;
    @Inject
    private ServerConfigManager m_manager;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private TopologyGraphDao m_topologyGraphDao;
    private TopologyGraphBuilder m_currentBuilder;
    private Map<Long, com.dianping.cat.home.dependency.graph.entity.TopologyGraph> m_topologyGraphs = new ConcurrentHashMap();
    private Logger m_logger;

    public Set<TopologyEdge> buildEdges(Set<String> domains, Date start, Date end) {
        HashSet<TopologyEdge> result = new HashSet<TopologyEdge>();
        for (long current = start.getTime(); current <= end.getTime(); current += 60000L) {
            result.addAll(this.buildEdges(domains, current));
        }
        return result;
    }

    public Set<TopologyEdge> buildEdges(Set<String> domains, long time) {
        com.dianping.cat.home.dependency.graph.entity.TopologyGraph topologyGraph = this.queryTopologyGraph(time);
        HashSet<TopologyEdge> result = new HashSet<TopologyEdge>();
        if (topologyGraph != null) {
            Map edges = topologyGraph.getEdges();
            for (TopologyEdge edge : edges.values()) {
                String self = edge.getSelf();
                String to = edge.getTarget();
                if (!domains.contains(self) || !domains.contains(to)) continue;
                result.add(this.m_currentBuilder.cloneEdge(edge));
            }
        }
        return result;
    }

    public ProductLinesDashboard buildDependencyDashboard(long time) {
        com.dianping.cat.home.dependency.graph.entity.TopologyGraph topologyGraph = this.queryTopologyGraph(time);
        ProductLinesDashboard dashboardGraph = new ProductLinesDashboard();
        HashSet<String> allDomains = new HashSet<String>();
        if (topologyGraph != null) {
            List productlines = this.m_configManager.queryProduct();
            for (ProductLine entry : productlines) {
                String productId = entry.getId();
                List domains = entry.getDomains();
                for (Domain domain : domains) {
                    String nodeName = domain.getId();
                    TopologyNode node = topologyGraph.findTopologyNode(nodeName);
                    allDomains.add(nodeName);
                    if (node == null) continue;
                    dashboardGraph.addNode(productId, this.m_currentBuilder.cloneNode(node));
                }
            }
            Map edges = topologyGraph.getEdges();
            for (TopologyEdge edge : edges.values()) {
                String self = edge.getSelf();
                String to = edge.getTarget();
                if (!allDomains.contains(self) || !allDomains.contains(to)) continue;
                dashboardGraph.addEdge(this.m_currentBuilder.cloneEdge(edge));
            }
        }
        return dashboardGraph.sortByNodeNumber();
    }

    public com.dianping.cat.home.dependency.graph.entity.TopologyGraph buildTopologyGraph(String domain, long time) {
        com.dianping.cat.home.dependency.graph.entity.TopologyGraph all = this.queryTopologyGraph(time);
        com.dianping.cat.home.dependency.graph.entity.TopologyGraph topylogyGraph = new com.dianping.cat.home.dependency.graph.entity.TopologyGraph();
        topylogyGraph.setId(domain);
        topylogyGraph.setType("project");
        topylogyGraph.setStatus(GraphConstrant.OK);
        if (all != null && this.m_currentBuilder != null) {
            TopologyNode node = all.findTopologyNode(domain);
            if (node != null) {
                topylogyGraph.setDes(node.getDes());
                topylogyGraph.setStatus(node.getStatus());
                topylogyGraph.setType(node.getType());
            }
            Collection edges = all.getEdges().values();
            for (TopologyEdge edge : edges) {
                TopologyNode other;
                String self = edge.getSelf();
                String target = edge.getTarget();
                TopologyEdge cloneEdge = this.m_currentBuilder.cloneEdge(edge);
                if (self.equals(domain)) {
                    other = all.findTopologyNode(target);
                    if (other != null) {
                        topylogyGraph.addTopologyNode(this.m_currentBuilder.cloneNode(other));
                    } else {
                        topylogyGraph.addTopologyNode(this.m_currentBuilder.createNode(target));
                    }
                    edge.setOpposite(false);
                    topylogyGraph.addTopologyEdge(cloneEdge);
                    continue;
                }
                if (!target.equals(domain)) continue;
                other = all.findTopologyNode(self);
                if (other != null) {
                    topylogyGraph.addTopologyNode(this.m_currentBuilder.cloneNode(other));
                } else {
                    topylogyGraph.addTopologyNode(this.m_currentBuilder.createNode(target));
                }
                cloneEdge.setTarget(edge.getSelf());
                cloneEdge.setSelf(edge.getTarget());
                cloneEdge.setOpposite(true);
                topylogyGraph.addTopologyEdge(cloneEdge);
            }
        }
        return topylogyGraph;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void initialize() throws InitializationException {
        if (this.m_manager.isJobMachine()) {
            Threads.forGroup((String)"cat").start((Runnable)new DependencyReloadTask(this, null));
        }
    }

    public com.dianping.cat.home.dependency.graph.entity.TopologyGraph queryGraphFromDB(long time) {
        try {
            TopologyGraph topologyGraph = this.m_topologyGraphDao.findByPeriod(new Date(time), TopologyGraphEntity.READSET_FULL);
            if (topologyGraph != null) {
                byte[] content = topologyGraph.getContent();
                return DefaultNativeParser.parse((byte[])content);
            }
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
        }
        return null;
    }

    private com.dianping.cat.home.dependency.graph.entity.TopologyGraph queryGraphFromMemory(long time) {
        com.dianping.cat.home.dependency.graph.entity.TopologyGraph graph = (com.dianping.cat.home.dependency.graph.entity.TopologyGraph)this.m_topologyGraphs.get(time);
        long current = System.currentTimeMillis();
        long minute = current - current % 60000L;
        if (minute - time <= 180000L && graph == null && (graph = (com.dianping.cat.home.dependency.graph.entity.TopologyGraph)this.m_topologyGraphs.get(time - 60000L)) == null) {
            graph = (com.dianping.cat.home.dependency.graph.entity.TopologyGraph)this.m_topologyGraphs.get(time - 120000L);
        }
        return graph;
    }

    private com.dianping.cat.home.dependency.graph.entity.TopologyGraph queryTopologyGraph(long time) {
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        if (period.isHistorical()) {
            return this.queryGraphFromDB(time);
        }
        return this.queryGraphFromMemory(time);
    }

    static /* synthetic */ ServerFilterConfigManager access$100(TopologyGraphManager x0) {
        return x0.m_serverFilterConfigManager;
    }

    static /* synthetic */ ModelService access$200(TopologyGraphManager x0) {
        return x0.m_service;
    }

    static /* synthetic */ Logger access$300(TopologyGraphManager x0) {
        return x0.m_logger;
    }

    static /* synthetic */ DependencyItemBuilder access$400(TopologyGraphManager x0) {
        return x0.m_itemBuilder;
    }

    static /* synthetic */ ProjectService access$500(TopologyGraphManager x0) {
        return x0.m_projectService;
    }

    static /* synthetic */ Map access$600(TopologyGraphManager x0) {
        return x0.m_topologyGraphs;
    }

    static /* synthetic */ TopologyGraphBuilder access$702(TopologyGraphManager x0, TopologyGraphBuilder x1) {
        x0.m_currentBuilder = x1;
        return x0.m_currentBuilder;
    }
}

