/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.dependency.DependencyReportMerger;
import com.dianping.cat.consumer.dependency.model.IVisitor;
import com.dianping.cat.consumer.dependency.model.entity.DependencyReport;
import com.dianping.cat.consumer.dependency.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Named;

@Named
public class DependencyReportService
extends AbstractReportService<DependencyReport> {
    public DependencyReport makeReport(String domain, Date start, Date end) {
        DependencyReport report = new DependencyReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public DependencyReport queryDailyReport(String domain, Date start, Date end) {
        throw new UnsupportedOperationException("Dependency report don't support daily report");
    }

    private DependencyReport queryFromHourlyBinary(int id, Date period, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, period, HourlyReportContentEntity.READSET_CONTENT);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new DependencyReport(domain);
    }

    public DependencyReport queryHourlyReport(String domain, Date start, Date end) {
        DependencyReportMerger merger = new DependencyReportMerger(new DependencyReport(domain));
        long endTime = end.getTime();
        String name = "dependency";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    DependencyReport reportModel = this.queryFromHourlyBinary(report.getId(), report.getPeriod(), domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        DependencyReport dependencyReport = merger.getDependencyReport();
        dependencyReport.setStartTime(start);
        dependencyReport.setEndTime(new Date(end.getTime() - 1L));
        return dependencyReport;
    }

    public DependencyReport queryMonthlyReport(String domain, Date start) {
        throw new UnsupportedOperationException("Dependency report don't support monthly report");
    }

    public DependencyReport queryWeeklyReport(String domain, Date start) {
        throw new UnsupportedOperationException("Dependency report don't support weekly report");
    }
}

