/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.dependency.model.entity.DependencyReport;
import com.dianping.cat.home.dal.report.TopologyGraph;
import com.dianping.cat.home.dal.report.TopologyGraphDao;
import com.dianping.cat.home.dependency.graph.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.dependency.graph.TopologyGraphBuilder;
import com.dianping.cat.report.page.dependency.service.DependencyReportService;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="dependency")
public class DependencyReportBuilder
implements TaskBuilder {
    public static final String ID = "dependency";
    @Inject
    private DependencyReportService m_reportService;
    @Inject
    private TopologyGraphBuilder m_graphBuilder;
    @Inject
    private TopologyGraphDao m_topologyGraphDao;

    public boolean buildDailyTask(String name, String reportDomain, Date reportPeriod) {
        throw new UnsupportedOperationException("no daily report builder for dependency!");
    }

    public boolean buildHourlyTask(String name, String reportDomain, Date reportPeriod) {
        Date end = new Date(reportPeriod.getTime() + 3600000L);
        Set domains = this.m_reportService.queryAllDomainNames(reportPeriod, end, ID);
        boolean result = true;
        this.m_graphBuilder.getGraphs().clear();
        for (String domain : domains) {
            DependencyReport report = (DependencyReport)this.m_reportService.queryReport(domain, reportPeriod, end);
            this.m_graphBuilder.visitDependencyReport(report);
        }
        Map graphs = this.m_graphBuilder.getGraphs();
        for (Map.Entry entry : graphs.entrySet()) {
            try {
                Date date = new Date((Long)entry.getKey());
                com.dianping.cat.home.dependency.graph.entity.TopologyGraph graph = (com.dianping.cat.home.dependency.graph.entity.TopologyGraph)entry.getValue();
                TopologyGraph proto = this.m_topologyGraphDao.createLocal();
                String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
                proto.setType(3);
                proto.setPeriod(date);
                proto.setCreationDate(new Date());
                proto.setIp(ip);
                proto.setContent(DefaultNativeBuilder.build((com.dianping.cat.home.dependency.graph.entity.TopologyGraph)graph));
                this.m_topologyGraphDao.insert(proto);
            }
            catch (Exception e) {
                result = false;
                Cat.logError((Throwable)e);
            }
        }
        return result;
    }

    public boolean buildMonthlyTask(String name, String reportDomain, Date reportPeriod) {
        throw new UnsupportedOperationException("no month report builder for dependency!");
    }

    public boolean buildWeeklyTask(String name, String reportDomain, Date reportPeriod) {
        throw new UnsupportedOperationException("no week report builder for dependency!");
    }
}

