/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.event;

import com.dianping.cat.consumer.event.model.entity.EventName;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.entity.EventType;
import com.dianping.cat.report.page.event.DisplayNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DisplayNames {
    private List<EventNameModel> m_results = new ArrayList();

    public DisplayNames display(String sorted, String type, String ip, EventReport report) {
        EventType names;
        Map types = report.findOrCreateMachine(ip).getTypes();
        EventName all = new EventName("TOTAL");
        all.setTotalPercent(1.0);
        if (types != null && (names = (EventType)types.get(type)) != null) {
            for (Map.Entry entry : names.getNames().entrySet()) {
                this.m_results.add(new EventNameModel((String)entry.getKey(), (EventName)entry.getValue()));
                this.mergeName(all, (EventName)entry.getValue());
            }
        }
        if (sorted == null) {
            sorted = "avg";
        }
        Collections.sort(this.m_results, new EventComparator(sorted));
        long total = all.getTotalCount();
        for (EventNameModel nameModel : this.m_results) {
            EventName eventName = nameModel.getDetail();
            eventName.setTotalPercent((double)eventName.getTotalCount() / (double)total);
        }
        this.m_results.add(0, new EventNameModel("TOTAL", all));
        return this;
    }

    public List<EventNameModel> getResults() {
        return this.m_results;
    }

    public void mergeName(EventName old, EventName other) {
        old.setTotalCount(old.getTotalCount() + other.getTotalCount());
        old.setFailCount(old.getFailCount() + other.getFailCount());
        if (old.getTotalCount() > 0L) {
            old.setFailPercent((double)old.getFailCount() * 100.0 / (double)old.getTotalCount());
        }
        if (old.getSuccessMessageUrl() == null) {
            old.setSuccessMessageUrl(other.getSuccessMessageUrl());
        }
        if (old.getFailMessageUrl() == null) {
            old.setFailMessageUrl(other.getFailMessageUrl());
        }
    }
}

