/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.event;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.event.model.entity.EventName;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.entity.EventType;
import com.dianping.cat.consumer.event.model.entity.Machine;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.graph.svg.GraphBuilder;
import com.dianping.cat.report.graph.svg.GraphPayload;
import com.dianping.cat.report.page.DomainGroupConfigManager;
import com.dianping.cat.report.page.event.Action;
import com.dianping.cat.report.page.event.Context;
import com.dianping.cat.report.page.event.DisplayNames;
import com.dianping.cat.report.page.event.DisplayTypes;
import com.dianping.cat.report.page.event.FailurePayload;
import com.dianping.cat.report.page.event.Handler;
import com.dianping.cat.report.page.event.HitPayload;
import com.dianping.cat.report.page.event.JspViewer;
import com.dianping.cat.report.page.event.Model;
import com.dianping.cat.report.page.event.Payload;
import com.dianping.cat.report.page.event.service.EventReportService;
import com.dianping.cat.report.page.event.transform.DistributionDetailVisitor;
import com.dianping.cat.report.page.event.transform.EventMergeHelper;
import com.dianping.cat.report.page.event.transform.EventTrendGraphBuilder;
import com.dianping.cat.report.page.event.transform.PieGraphChartVisitor;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private GraphBuilder m_builder;
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private EventReportService m_reportService;
    @Inject
    private EventMergeHelper m_mergeHelper;
    @Inject(type=ModelService.class, value={"event"})
    private ModelService<EventReport> m_service;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private DomainGroupConfigManager m_configManager;

    private void buildDistributionInfo(Model model, String type, String name, EventReport report) {
        PieGraphChartVisitor chartVisitor = new PieGraphChartVisitor(type, name);
        DistributionDetailVisitor detailVisitor = new DistributionDetailVisitor(type, name);
        chartVisitor.visitEventReport(report);
        detailVisitor.visitEventReport(report);
        model.setDistributionChart(chartVisitor.getPieChart().getJsonString());
        model.setDistributionDetails(detailVisitor.getDetails());
    }

    private void buildEventMetaInfo(Model model, Payload payload, EventReport report) {
        String type = payload.getType();
        String sorted = payload.getSortBy();
        String ip = payload.getIpAddress();
        if (!StringUtils.isEmpty((String)type)) {
            DisplayNames displayNames = new DisplayNames();
            model.setDisplayNameReport(displayNames.display(sorted, type, ip, report));
            this.buildEventNamePieChart(displayNames.getResults(), model);
        } else {
            model.setDisplayTypeReport(new DisplayTypes().display(sorted, ip, report));
        }
    }

    private void buildEventNameGraph(Model model, EventReport report, String type, String name, String ip) {
        EventType t = report.findOrCreateMachine(ip).findOrCreateType(type);
        EventName eventName = t.findOrCreateName(name);
        if (eventName != null) {
            String graph1 = this.m_builder.build((GraphPayload)new HitPayload("Hits Over Time", "Time (min)", "Count", eventName));
            String graph2 = this.m_builder.build((GraphPayload)new FailurePayload("Failures Over Time", "Time (min)", "Count", eventName));
            model.setGraph1(graph1);
            model.setGraph2(graph2);
        }
    }

    private void buildEventNamePieChart(List<DisplayNames.EventNameModel> names, Model model) {
        PieChart chart = new PieChart();
        ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
        for (int i = 1; i < names.size(); ++i) {
            DisplayNames.EventNameModel name = names.get(i);
            PieChart.Item item = new PieChart.Item();
            EventName event = name.getDetail();
            item.setNumber((double)event.getTotalCount()).setTitle(event.getId());
            items.add(item);
        }
        chart.addItems(items);
        model.setPieChart(new JsonBuilder().toJson((Object)chart));
    }

    private EventReport filterReportByGroup(EventReport report, String domain, String group) {
        List ips = this.m_configManager.queryIpByDomainAndGroup(domain, group);
        ArrayList<String> removes = new ArrayList<String>();
        for (Machine machine : report.getMachines().values()) {
            String ip = machine.getIp();
            if (ips.contains(ip)) continue;
            removes.add(ip);
        }
        for (String ip : removes) {
            report.getMachines().remove(ip);
        }
        return report;
    }

    private EventReport getHourlyGraphReport(Model model, Payload payload) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        String name = payload.getName();
        if (name == null || name.length() == 0) {
            name = "*";
        }
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("type", payload.getType()).setProperty("name", name).setProperty("ip", ipAddress);
        ModelResponse response = this.m_service.invoke(request);
        EventReport report = (EventReport)response.getModel();
        return report;
    }

    private EventReport getHourlyReport(Payload payload) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("type", payload.getType()).setProperty("ip", ipAddress);
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            EventReport report = (EventReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligable event service registered for " + request + "!");
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="e")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="e")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Cat.logMetricForCount((String)"http-request-event");
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.normalize(model, payload);
        String domain = payload.getDomain();
        Action action = payload.getAction();
        String ipAddress = payload.getIpAddress();
        String group = payload.getGroup();
        String type = payload.getType();
        String name = payload.getName();
        String ip = payload.getIpAddress();
        if (StringUtils.isEmpty((String)group)) {
            group = this.m_configManager.queryDefaultGroup(domain);
            payload.setGroup(group);
        }
        model.setGroupIps(this.m_configManager.queryIpByDomainAndGroup(domain, group));
        model.setGroups(this.m_configManager.queryDomainGroup(payload.getDomain()));
        switch (1.$SwitchMap$com$dianping$cat$report$page$event$Action[action.ordinal()]) {
            case 1: {
                EventReport report = this.getHourlyReport(payload);
                report = this.m_mergeHelper.mergeAllIps(report, ipAddress);
                if (report == null) break;
                model.setReport(report);
                this.buildEventMetaInfo(model, payload, report);
                break;
            }
            case 2: {
                EventReport report = (EventReport)this.m_reportService.queryReport(domain, payload.getHistoryStartDate(), payload.getHistoryEndDate());
                report = this.m_mergeHelper.mergeAllIps(report, ipAddress);
                if (report == null) break;
                model.setReport(report);
                this.buildEventMetaInfo(model, payload, report);
                break;
            }
            case 3: {
                EventReport report = (EventReport)this.m_reportService.queryReport(domain, payload.getHistoryStartDate(), payload.getHistoryEndDate());
                if ("All".equalsIgnoreCase(ipAddress)) {
                    this.buildDistributionInfo(model, type, name, report);
                }
                report = this.m_mergeHelper.mergeAllIps(report, ipAddress);
                new EventTrendGraphBuilder().buildTrendGraph(model, payload, report);
                break;
            }
            case 4: {
                EventReport report = this.getHourlyGraphReport(model, payload);
                if ("All".equalsIgnoreCase(ipAddress)) {
                    this.buildDistributionInfo(model, type, name, report);
                }
                report = this.m_mergeHelper.mergeAllIps(report, ipAddress);
                if (name == null || name.length() == 0) {
                    name = "All";
                    report = this.m_mergeHelper.mergeAllNames(report, ip, name);
                }
                model.setReport(report);
                this.buildEventNameGraph(model, report, type, name, ip);
                break;
            }
            case 5: {
                EventReport report = this.getHourlyReport(payload);
                report = this.filterReportByGroup(report, domain, group);
                report = this.m_mergeHelper.mergeAllIps(report, ipAddress);
                if (report == null) break;
                model.setReport(report);
                this.buildEventMetaInfo(model, payload, report);
                break;
            }
            case 6: {
                EventReport report = (EventReport)this.m_reportService.queryReport(domain, payload.getHistoryStartDate(), payload.getHistoryEndDate());
                report = this.filterReportByGroup(report, domain, group);
                report = this.m_mergeHelper.mergeAllIps(report, ipAddress);
                if (report == null) break;
                model.setReport(report);
                this.buildEventMetaInfo(model, payload, report);
                break;
            }
            case 7: {
                EventReport report = this.getHourlyGraphReport(model, payload);
                report = this.filterReportByGroup(report, domain, group);
                this.buildDistributionInfo(model, type, name, report);
                if (name == null || name.length() == 0) {
                    name = "All";
                }
                report = this.m_mergeHelper.mergeAllNames(report, ip, name);
                model.setReport(report);
                this.buildEventNameGraph(model, report, type, name, ip);
                break;
            }
            case 8: {
                EventReport report = (EventReport)this.m_reportService.queryReport(domain, payload.getHistoryStartDate(), payload.getHistoryEndDate());
                report = this.filterReportByGroup(report, domain, group);
                this.buildDistributionInfo(model, type, name, report);
                report = this.m_mergeHelper.mergeAllIps(report, ip);
                new EventTrendGraphBuilder().buildTrendGraph(model, payload, report);
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.EVENT);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        if (StringUtils.isEmpty((String)payload.getType())) {
            payload.setType(null);
        }
    }
}

