/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat.service;

import com.dianping.cat.consumer.heartbeat.HeartbeatReportMerger;
import com.dianping.cat.consumer.heartbeat.model.IEntity;
import com.dianping.cat.consumer.heartbeat.model.IVisitor;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.transform.DefaultSaxParser;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.heartbeat.service.LocalHeartbeatService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.util.StringUtils;

@Named(type=LocalModelService.class, value="heartbeat")
public class LocalHeartbeatService
extends LocalModelService<HeartbeatReport> {
    public static final String ID = "heartbeat";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalHeartbeatService() {
        super(ID);
    }

    private String filterReport(ApiPayload payload, HeartbeatReport report) {
        Set ips;
        String ipAddress = payload.getIpAddress();
        if (StringUtils.isEmpty((String)ipAddress) && (ips = report.getIps()).size() > 0) {
            ipAddress = (String)SortHelper.sortIpAddress((Collection)ips).get(0);
        }
        HeartBeatReportFilter filter = new HeartBeatReportFilter(ipAddress, payload.getMin(), payload.getMax());
        return filter.buildXml((IEntity)report);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        List reports = super.getReport(period, domain);
        HeartbeatReport report = null;
        if (reports != null) {
            report = new HeartbeatReport(domain);
            HeartbeatReportMerger merger = new HeartbeatReportMerger(report);
            for (HeartbeatReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getIps().isEmpty()) && period.isLast()) {
            long startTime = request.getStartTime();
            report = this.getReportFromLocalDisk(startTime, domain);
        }
        return this.filterReport(payload, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeartbeatReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        HeartbeatReport report = new HeartbeatReport(domain);
        HeartbeatReportMerger merger = new HeartbeatReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml == null) continue;
                HeartbeatReport tmp = DefaultSaxParser.parse((String)xml);
                tmp.accept((IVisitor)merger);
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

