/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.logview.service;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.message.CodecHandler;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.codec.HtmlMessageCodec;
import com.dianping.cat.message.codec.WaterfallMessageCodec;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.storage.MessageBucketManager;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import org.unidal.cat.message.storage.Bucket;
import org.unidal.cat.message.storage.BucketManager;
import org.unidal.cat.message.storage.MessageFinderManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=LocalModelService.class, value="logview")
public class LocalMessageService
extends LocalModelService<String>
implements ModelService<String> {
    public static final String ID = "dump";
    @Inject
    private MessageFinderManager m_finderManager;
    @Inject(value={"local"})
    private BucketManager m_bucketManager;
    @Inject(type=MessageBucketManager.class, value={"local"})
    private MessageBucketManager m_messageBucketManager;
    private WaterfallMessageCodec m_waterfall = new WaterfallMessageCodec();
    private HtmlMessageCodec m_html = new HtmlMessageCodec();

    public LocalMessageService() {
        super("logview");
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        String result = this.buildOldReport(request, period, domain, payload);
        if (result == null) {
            result = this.buildNewReport(request, period, domain, payload);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildNewReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        String messageId = payload.getMessageId();
        boolean waterfall = payload.isWaterfall();
        MessageId id = MessageId.parse((String)messageId);
        ByteBuf buf = this.m_finderManager.find(id);
        MessageTree tree = null;
        try {
            Bucket bucket;
            if (buf != null) {
                tree = CodecHandler.decode((ByteBuf)buf);
            }
            if (tree == null && (bucket = this.m_bucketManager.getBucket(id.getDomain(), NetworkInterfaceManager.INSTANCE.getLocalHostAddress(), id.getHour(), false)) != null) {
                bucket.flush();
                ByteBuf data = bucket.get(id);
                if (data != null) {
                    tree = CodecHandler.decode((ByteBuf)data);
                }
            }
        }
        finally {
            CodecHandler.reset();
        }
        if (tree != null) {
            ByteBuf content = ByteBufAllocator.DEFAULT.buffer(8192);
            if (tree.getMessage() instanceof Transaction && waterfall) {
                this.m_waterfall.encode(tree, content);
            } else {
                this.m_html.encode(tree, content);
            }
            try {
                content.readInt();
                return content.toString(Charset.forName("utf-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String buildOldReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        String messageId = payload.getMessageId();
        boolean waterfall = payload.isWaterfall();
        MessageTree tree = this.m_messageBucketManager.loadMessage(messageId);
        if (tree != null) {
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(8192);
            if (tree.getMessage() instanceof Transaction && waterfall) {
                this.m_waterfall.encode(tree, buf);
            } else {
                this.m_html.encode(tree, buf);
            }
            try {
                buf.readInt();
                return buf.toString(Charset.forName("utf-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelResponse<String> invoke(ModelRequest request) {
        ModelResponse response = new ModelResponse();
        Transaction t = Cat.newTransaction((String)"ModelService", (String)this.getClass().getSimpleName());
        try {
            ModelPeriod period = request.getPeriod();
            String domain = request.getDomain();
            ApiPayload payload = new ApiPayload();
            payload.setMessageId(request.getProperty("messageId"));
            payload.setWaterfall(Boolean.valueOf(request.getProperty("waterfall", "false")).booleanValue());
            String report = this.getReport(request, period, domain, payload);
            response.setModel((Object)report);
            t.addData("period", (Object)period);
            t.addData("domain", (Object)domain);
            t.setStatus("0");
        }
        catch (Exception e) {
            e.printStackTrace();
            Cat.logError((Throwable)e);
            t.setStatus((Throwable)e);
            response.setException(e);
        }
        finally {
            t.complete();
        }
        return response;
    }

    public boolean isEligable(ModelRequest request) {
        if (this.m_configManager.isHdfsOn()) {
            return request.getPeriod().isCurrent();
        }
        return true;
    }
}

