/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.matrix;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.matrix.model.entity.Matrix;
import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.report.page.matrix.DisplayMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DisplayMatrix {
    private Map<String, MatrixItem> m_matrix = new TreeMap();
    private String m_sortBy = "name";

    public DisplayMatrix(MatrixReport report) {
        if (report == null) {
            return;
        }
        Map reportMatrixs = report.getMatrixs();
        for (Matrix matrix : reportMatrixs.values()) {
            String key = matrix.getName();
            MatrixItem item = (MatrixItem)this.m_matrix.get(key);
            if (item == null) {
                item = new MatrixItem();
                item.setBaseInfo(matrix);
                item.setCacheInfo(matrix);
                item.setCallInfo(matrix);
                item.setSQLInfo(matrix);
                this.m_matrix.put(key, item);
                continue;
            }
            Cat.logError((Throwable)new RuntimeException("Inter errer in matrix analyers!"));
        }
    }

    public List<MatrixItem> getMatrixs() {
        ArrayList<MatrixItem> result = new ArrayList<MatrixItem>(this.m_matrix.values());
        Collections.sort(result, new MatrixItemCompartor(this.m_sortBy));
        return result;
    }

    public DisplayMatrix setSortBy(String sort) {
        if (sort != null) {
            this.m_sortBy = sort;
        }
        return this;
    }
}

