/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.metric.service;

import com.dianping.cat.Cat;
import com.dianping.cat.home.dal.report.Baseline;
import com.dianping.cat.home.dal.report.BaselineDao;
import com.dianping.cat.home.dal.report.BaselineEntity;
import com.dianping.cat.report.page.metric.service.BaselineService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.task.TaskHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=BaselineService.class)
public class DefaultBaselineService
implements BaselineService {
    @Inject
    private BaselineDao m_baselineDao;
    private Map<String, Baseline> m_baselines = new /* Unavailable Anonymous Inner Class!! */;
    private Map<String, String> m_empties = new /* Unavailable Anonymous Inner Class!! */;

    private double[] decodeBaselines(byte[] datas) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(datas);
        DataInputStream dataInput = new DataInputStream(input);
        int size = dataInput.readInt();
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = dataInput.readDouble();
        }
        return result;
    }

    private byte[] encodeBaselines(double[] dataInDoubleArray) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DataOutputStream output = new DataOutputStream(out);
        output.writeInt(dataInDoubleArray.length);
        for (double dataItem : dataInDoubleArray) {
            output.writeDouble(dataItem);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getEmpties() {
        DefaultBaselineService defaultBaselineService = this;
        synchronized (defaultBaselineService) {
            return this.m_empties;
        }
    }

    public boolean hasDailyBaseline(String reportName, String key, Date reportPeriod) {
        String baselineKey = reportName + ":" + key + ":" + reportPeriod;
        Baseline baseline = (Baseline)this.m_baselines.get(baselineKey);
        boolean has = false;
        if (baseline != null) {
            has = true;
        } else {
            try {
                baseline = this.m_baselineDao.findByReportNameKeyTime(reportPeriod, reportName, key, BaselineEntity.READSET_FULL);
                has = true;
            }
            catch (DalNotFoundException dalNotFoundException) {
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return has;
    }

    public void insertBaseline(Baseline baseline) {
        try {
            baseline.setData(this.encodeBaselines(baseline.getDataInDoubleArray()));
            this.m_baselineDao.insert(baseline);
            String baselineKey = baseline.getReportName() + ":" + baseline.getIndexKey() + ":" + baseline.getReportPeriod();
            this.getEmpties().remove(baselineKey);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public double[] mergerArray(double[] from, double[] to) {
        int i;
        int fromLength = from.length;
        int toLength = to.length;
        double[] result = new double[fromLength + toLength];
        int index = 0;
        for (i = 0; i < fromLength; ++i) {
            result[i] = from[i];
            ++index;
        }
        for (i = 0; i < toLength; ++i) {
            result[i + index] = to[i];
        }
        return result;
    }

    public double[] queryBaseline(int currentMinute, int ruleMinute, String metricKey, String name) {
        double[] baseline = new double[ruleMinute];
        if (currentMinute >= ruleMinute - 1) {
            int start = currentMinute + 1 - ruleMinute;
            int end = currentMinute;
            baseline = this.queryBaseLine(start, end, metricKey, new Date(ModelPeriod.CURRENT.getStartTime()), name);
        } else if (currentMinute < 0) {
            int start = 60 + currentMinute + 1 - ruleMinute;
            int end = 60 + currentMinute;
            baseline = this.queryBaseLine(start, end, metricKey, new Date(ModelPeriod.LAST.getStartTime()), name);
        } else {
            int currentStart = 0;
            int currentEnd = currentMinute;
            double[] currentBaseline = this.queryBaseLine(currentStart, currentEnd, metricKey, new Date(ModelPeriod.CURRENT.getStartTime()), name);
            int lastStart = 61 - (ruleMinute - currentMinute);
            int lastEnd = 59;
            double[] lastBaseline = this.queryBaseLine(lastStart, lastEnd, metricKey, new Date(ModelPeriod.LAST.getStartTime()), name);
            baseline = this.mergerArray(lastBaseline, currentBaseline);
        }
        return baseline;
    }

    private double[] queryBaseLine(int start, int end, String key, Date date, String name) {
        double[] baseline = this.queryHourlyBaseline(name, key, date);
        int length = end - start + 1;
        double[] result = new double[length];
        if (baseline != null) {
            System.arraycopy(baseline, start, result, 0, length);
        }
        return result;
    }

    public double[] queryDailyBaseline(String reportName, String key, Date reportPeriod) {
        String baselineKey = reportName + ":" + key + ":" + reportPeriod;
        Baseline baseline = (Baseline)this.m_baselines.get(baselineKey);
        if (baseline == null) {
            try {
                boolean has = this.getEmpties().containsKey(baselineKey);
                if (has) {
                    return null;
                }
                baseline = this.m_baselineDao.findByReportNameKeyTime(reportPeriod, reportName, key, BaselineEntity.READSET_FULL);
                this.m_baselines.put(baselineKey, baseline);
            }
            catch (DalNotFoundException e) {
                this.getEmpties().put(baselineKey, baselineKey);
                return null;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return null;
            }
        }
        try {
            return this.decodeBaselines(baseline.getData());
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    public double[] queryHourlyBaseline(String reportName, String key, Date reportPeriod) {
        double[] result = new double[60];
        Date today = TaskHelper.todayZero((Date)reportPeriod);
        int hour = (int)((reportPeriod.getTime() - today.getTime()) / 3600000L);
        double[] dayResult = this.queryDailyBaseline(reportName, key, today);
        if (dayResult != null) {
            for (int i = 0; i < 60; ++i) {
                result[i] = dayResult[hour * 60 + i];
            }
        }
        return result;
    }
}

