/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.overload.task;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentDao;
import com.dianping.cat.core.dal.MonthlyReportContentEntity;
import com.dianping.cat.core.dal.MonthlyReportDao;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.home.dal.report.Overload;
import com.dianping.cat.home.dal.report.OverloadDao;
import com.dianping.cat.report.page.overload.task.CapacityUpdateStatusManager;
import com.dianping.cat.report.page.overload.task.CapacityUpdater;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=CapacityUpdater.class, value="monthly_capacity_updater")
public class MonthlyCapacityUpdater
implements CapacityUpdater {
    public static final String ID = "monthly_capacity_updater";
    @Inject
    private MonthlyReportDao m_monthlyReportDao;
    @Inject
    private MonthlyReportContentDao m_monthlyReportContentDao;
    @Inject
    private OverloadDao m_overloadDao;
    @Inject
    private CapacityUpdateStatusManager m_manager;

    public String getId() {
        return ID;
    }

    public void updateDBCapacity() throws DalException {
        int maxId = this.m_manager.getMonthlyStatus();
        while (true) {
            List reports = this.m_monthlyReportContentDao.findOverloadReport(maxId, MonthlyReportContentEntity.READSET_LENGTH);
            for (MonthlyReportContent content : reports) {
                try {
                    int reportId = content.getReportId();
                    double contentLength = content.getContentLength();
                    if (!(contentLength >= 15.0)) continue;
                    Overload overload = this.m_overloadDao.createLocal();
                    overload.setReportId(reportId);
                    overload.setReportSize(contentLength);
                    overload.setReportType(4);
                    try {
                        MonthlyReport report = this.m_monthlyReportDao.findByPK(reportId, MonthlyReportEntity.READSET_FULL);
                        overload.setPeriod(report.getPeriod());
                        this.m_overloadDao.insert(overload);
                    }
                    catch (DalNotFoundException report) {
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                catch (Exception ex) {
                    Cat.logError((Throwable)ex);
                }
            }
            int size = reports.size();
            if (size == 0) break;
            maxId = ((MonthlyReportContent)reports.get(size - 1)).getReportId();
        }
        this.m_manager.updateMonthlyStatus(maxId);
    }
}

