/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.problem.ProblemReportFilter;
import com.dianping.cat.consumer.problem.ProblemReportMerger;
import com.dianping.cat.consumer.problem.model.IVisitor;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.report.page.problem.service.ProblemReportService;
import com.dianping.cat.report.page.problem.task.HistoryProblemReportMerger;
import com.dianping.cat.report.page.problem.task.ProblemReportDailyGraphCreator;
import com.dianping.cat.report.page.problem.task.ProblemReportHourlyGraphCreator;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import com.dianping.cat.report.task.current.CurrentWeeklyMonthlyReportTask;
import java.util.Date;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="problem")
public class ProblemReportBuilder
implements TaskBuilder,
Initializable {
    public static final String ID = "problem";
    @Inject
    protected ProblemReportService m_reportService;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            ProblemReport problemReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((ProblemReport)problemReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("problem report don't support HourlyReport!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        ProblemReport problemReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        new ProblemReportFilter().visitProblemReport(problemReport);
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ProblemReport)problemReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        ProblemReport problemReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ProblemReport)problemReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    public void initialize() throws InitializationException {
        CurrentWeeklyMonthlyReportTask.getInstance().register((CurrentWeeklyMonthlyReportTask.CurrentWeeklyMonthlyTask)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ProblemReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long startTime;
        long endTime = end.getTime();
        double duration = (double)(endTime - startTime) * 1.0 / 8.64E7;
        ProblemReportMerger merger = new ProblemReportMerger(new ProblemReport(domain));
        ProblemReport problemReport = merger.getProblemReport();
        ProblemReportDailyGraphCreator creator = new ProblemReportDailyGraphCreator(problemReport, (int)duration, start);
        for (startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                ProblemReport reportModel = (ProblemReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                creator.createGraph(reportModel);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        problemReport.setStartTime(start);
        problemReport.setEndTime(end);
        return problemReport;
    }

    private ProblemReport queryHourlyReportsByDuration(String name, String domain, Date start, Date endDate) throws DalException {
        long endTime = endDate.getTime();
        HistoryProblemReportMerger merger = new HistoryProblemReportMerger(new ProblemReport(domain));
        ProblemReportHourlyGraphCreator graphCreator = new ProblemReportHourlyGraphCreator(merger.getProblemReport(), 10);
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            ProblemReport report = (ProblemReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
            graphCreator.createGraph(report);
            report.accept((IVisitor)merger);
        }
        ProblemReport dailyReport = merger.getProblemReport();
        Date date = dailyReport.getStartTime();
        Date end = new Date(TaskHelper.tomorrowZero((Date)date).getTime() - 1000L);
        dailyReport.setStartTime(TaskHelper.todayZero((Date)date));
        dailyReport.setEndTime(end);
        return dailyReport;
    }
}

