/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.transform;

import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.JavaThread;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.Segment;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.report.page.problem.transform.DetailStatistics;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.unidal.lookup.util.StringUtils;

public class DetailStatistics
extends BaseVisitor {
    private String m_groupName;
    private String m_ip = "";
    private int m_minute;
    private Map<String, TypeStatistics> m_status = new TreeMap();
    private String m_threadId;

    public Map<String, TypeStatistics> getStatus() {
        return this.m_status;
    }

    public String getSubTitle() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)this.m_threadId) && StringUtils.isEmpty((String)this.m_groupName)) {
            return "All Thread Groups";
        }
        if (!StringUtils.isEmpty((String)this.m_groupName) && StringUtils.isEmpty((String)this.m_threadId)) {
            return "All Threads in Group:" + this.m_groupName;
        }
        if (!StringUtils.isEmpty((String)this.m_groupName) && !StringUtils.isEmpty((String)this.m_threadId)) {
            return "Thread :" + this.m_threadId;
        }
        return sb.toString();
    }

    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.m_groupName)) {
            sb.append("&group=").append(this.m_groupName);
        }
        if (!StringUtils.isEmpty((String)this.m_threadId)) {
            sb.append("&thread=").append(this.m_threadId);
        }
        return sb.toString();
    }

    private boolean isContents(String groupName, String threadId) {
        if (this.m_groupName != null && !this.m_groupName.equals(groupName)) {
            return false;
        }
        return this.m_threadId == null || this.m_threadId.equals(threadId);
    }

    public DetailStatistics setGroupName(String groupName) {
        this.m_groupName = groupName;
        return this;
    }

    public DetailStatistics setIp(String ip) {
        this.m_ip = ip;
        return this;
    }

    public DetailStatistics setMinute(int minute) {
        this.m_minute = minute;
        return this;
    }

    public DetailStatistics setThreadId(String threadId) {
        this.m_threadId = threadId;
        return this;
    }

    private void statisticsSegment(Segment segment, String type, String status) {
        TypeStatistics statusValue = (TypeStatistics)this.m_status.get(type);
        if (statusValue == null) {
            statusValue = new TypeStatistics(type);
            this.m_status.put(type, statusValue);
        }
        statusValue.statics(status, segment);
    }

    public void visitMachine(Machine machine) {
        if (machine.getIp().equals(this.m_ip)) {
            Collection entities = machine.getEntities().values();
            for (Entity entity : entities) {
                Map threads = entity.getThreads();
                for (JavaThread thread : threads.values()) {
                    Segment segment;
                    String threadId = thread.getId();
                    String groupName = thread.getGroupName();
                    if (!this.isContents(groupName, threadId) || (segment = (Segment)thread.getSegments().get(this.m_minute)) == null) continue;
                    this.statisticsSegment(segment, entity.getType(), entity.getStatus());
                }
            }
        }
    }
}

