/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.state;

import com.dianping.cat.consumer.state.model.entity.Machine;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;

/*
 * Exception performing whole class analysis ignored.
 */
public class StateBuilder {
    public static final int COUNT = 5000000;
    @Inject
    private RouterConfigManager m_routerManager;
    @Inject(type=ModelService.class, value={"state"})
    private ModelService<StateReport> m_stateService;

    public static boolean checkTooMuchLoss(Machine machine) {
        return machine.getTotalLoss() > 5000000L;
    }

    public String buildStateMessage(long date, String ip) {
        StateReport report = this.queryHourlyReport(date, ip);
        if (report != null) {
            int realSize = report.getMachines().size();
            List servers = this.queryAllServers();
            int excepeted = servers.size();
            HashSet<String> errorServers = new HashSet<String>();
            if (realSize != excepeted) {
                for (String serverIp : servers) {
                    if (report.getMachines().get(serverIp) != null) continue;
                    errorServers.add(serverIp);
                }
            }
            for (Machine machine : report.getMachines().values()) {
                if (!StateBuilder.checkTooMuchLoss((Machine)machine)) continue;
                errorServers.add(machine.getIp());
            }
            if (errorServers.size() > 0) {
                return ((Object)errorServers).toString();
            }
        }
        return null;
    }

    private List<String> queryAllServers() {
        ArrayList<String> strs = new ArrayList<String>();
        String backUpServer = this.m_routerManager.getRouterConfig().getBackupServer();
        Map servers = this.m_routerManager.getRouterConfig().getDefaultServers();
        for (Map.Entry server : servers.entrySet()) {
            strs.add(((DefaultServer)server.getValue()).getId());
        }
        strs.add(backUpServer);
        return strs;
    }

    private StateReport queryHourlyReport(long date, String ip) {
        String domain = "cat";
        ModelRequest request = new ModelRequest(domain, date).setProperty("ip", ip);
        if (this.m_stateService.isEligable(request)) {
            ModelResponse response = this.m_stateService.invoke(request);
            return (StateReport)response.getModel();
        }
        throw new RuntimeException("Internal error: no eligable sql service registered for " + request + "!");
    }
}

