/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.heavy;

import com.dianping.cat.consumer.matrix.model.entity.Matrix;
import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.consumer.matrix.model.entity.Ratio;
import com.dianping.cat.consumer.matrix.model.transform.BaseVisitor;
import com.dianping.cat.home.heavy.entity.HeavyCache;
import com.dianping.cat.home.heavy.entity.HeavyCall;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.entity.HeavySql;
import com.dianping.cat.home.heavy.entity.Service;
import com.dianping.cat.home.heavy.entity.Url;

public class MatrixReportVisitor
extends BaseVisitor {
    private HeavyReport m_report;
    private String m_currentDomain;
    private String m_currentType;
    private String m_currentName;

    public MatrixReportVisitor setReport(HeavyReport report) {
        this.m_report = report;
        return this;
    }

    private void updateService(Service service, String logview, long max) {
        service.setDomain(this.m_currentDomain);
        service.setName(this.m_currentName);
        if (max > service.getCount()) {
            service.setLogview(logview);
            service.setCount(max);
        }
    }

    private void updateUrl(Url url, String logview, long max) {
        url.setDomain(this.m_currentDomain);
        url.setName(this.m_currentName);
        if (max > url.getCount()) {
            url.setLogview(logview);
            url.setCount(max);
        }
    }

    public void visitMatrix(Matrix matrix) {
        this.m_currentType = matrix.getType();
        this.m_currentName = matrix.getName();
        super.visitMatrix(matrix);
    }

    public void visitMatrixReport(MatrixReport matrixReport) {
        this.m_currentDomain = matrixReport.getDomain();
        if (this.m_report.getHeavyCache() == null) {
            this.m_report.setHeavyCache(new HeavyCache());
        }
        if (this.m_report.getHeavyCall() == null) {
            this.m_report.setHeavyCall(new HeavyCall());
        }
        if (this.m_report.getHeavySql() == null) {
            this.m_report.setHeavySql(new HeavySql());
        }
        super.visitMatrixReport(matrixReport);
    }

    public void visitRatio(Ratio ratio) {
        String type = ratio.getType();
        long max = ratio.getMax();
        String logview = ratio.getUrl();
        if ("Call".equals(type)) {
            HeavyCall call = this.m_report.getHeavyCall();
            String key = this.m_currentDomain + ":" + this.m_currentName;
            if (this.m_currentType.equals("URL")) {
                if (max > 10L) {
                    Url url = call.findOrCreateUrl(key);
                    this.updateUrl(url, logview, max);
                }
            } else if (max > 10L) {
                Service service = call.findOrCreateService(key);
                this.updateService(service, logview, max);
            }
        } else if ("SQL".equals(type)) {
            HeavySql sql = this.m_report.getHeavySql();
            String key = this.m_currentDomain + ":" + this.m_currentName;
            if (this.m_currentType.equals("URL")) {
                if (max > 20L) {
                    Url url = sql.findOrCreateUrl(key);
                    this.updateUrl(url, logview, max);
                }
            } else if (max > 20L) {
                Service service = sql.findOrCreateService(key);
                this.updateService(service, logview, max);
            }
        } else if ("Cache".equals(type)) {
            HeavyCache cache = this.m_report.getHeavyCache();
            String key = this.m_currentDomain + ":" + this.m_currentName;
            if (this.m_currentType.equals("URL")) {
                if (max > 100L) {
                    Url url = cache.findOrCreateUrl(key);
                    this.updateUrl(url, logview, max);
                }
            } else if (max > 100L) {
                Service service = cache.findOrCreateService(key);
                this.updateService(service, logview, max);
            }
        }
    }
}

