/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.service;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.service.client.entity.ClientReport;
import com.dianping.cat.home.service.client.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.statistics.service.ClientReportService;
import com.dianping.cat.report.page.statistics.task.service.ClientReportStatistics;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.page.transaction.transform.TransactionMergeHelper;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.service.ProjectService;
import java.util.Date;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="client")
public class ClientReportBuilder
implements TaskBuilder {
    public static final String ID = "client";
    @Inject
    protected ClientReportService m_reportService;
    @Inject
    protected TransactionReportService m_transactionReportService;
    @Inject
    private ServerFilterConfigManager m_configManger;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private TransactionMergeHelper m_mergeHelper;

    public boolean buildDailyTask(String name, String domain, Date period) {
        ClientReport clientReport = this.buildClientReport(period);
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ClientReport)clientReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    private ClientReport buildClientReport(Date startTime) {
        Date endTime = TimeHelper.addDays((Date)startTime, (int)1);
        Set domains = this.m_projectService.findAllDomains();
        ClientReportStatistics statistics = new ClientReportStatistics();
        for (String domain : domains) {
            try {
                if (!this.m_configManger.validateDomain(domain)) continue;
                TransactionReport r = (TransactionReport)this.m_transactionReportService.queryReport(domain, startTime, endTime);
                if ((r = this.m_mergeHelper.mergeAllMachines(r, "All")) == null) continue;
                statistics.visitTransactionReport(r);
            }
            catch (Exception e) {
                Cat.logError((String)(domain + " client report visitor error"), (Throwable)e);
            }
        }
        return statistics.getClienReport();
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("Service client report don't support hourly report!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("Service client report don't support monthly report!");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("Service client report don't support weekly report!");
    }
}

