/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.utilization;

import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.entity.Machine;
import com.dianping.cat.consumer.heartbeat.model.entity.Period;
import com.dianping.cat.consumer.heartbeat.model.transform.BaseVisitor;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.MachineState;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import java.util.ArrayList;
import java.util.List;

public class HeartbeatReportVisitor
extends BaseVisitor {
    private List<Double> m_newGcs;
    private List<Double> m_fullGcs;
    private List<Double> m_loads;
    private String m_domain;
    private UtilizationReport m_report;

    private double computeAvg(List<Double> values) {
        double sum = 0.0;
        for (Double d : values) {
            sum += d.doubleValue();
        }
        int size = values.size();
        if (size > 0) {
            return sum / (double)values.size();
        }
        return 0.0;
    }

    private double computeDuration(List<Double> values) {
        double sum = 0.0;
        int size = values.size();
        for (int i = 0; i < size - 1; ++i) {
            double first = values.get(i);
            double next = values.get(i + 1);
            double duration = next - first;
            if (!(duration > 0.0)) continue;
            sum += duration;
        }
        return sum;
    }

    private double findMax(List<Double> values) {
        double max = 0.0;
        for (Double d : values) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public HeartbeatReportVisitor setUtilizationReport(UtilizationReport report) {
        this.m_report = report;
        return this;
    }

    private void updateMachineState(MachineState state, double value, double maxValue) {
        state.setSum(state.getSum() + value);
        state.setCount(state.getCount() + 1L);
        state.setAvg(state.getSum() / (double)state.getCount());
        if (maxValue > state.getAvgMax()) {
            state.setAvgMax(maxValue);
        }
    }

    public void visitHeartbeatReport(HeartbeatReport heartbeatReport) {
        this.m_domain = heartbeatReport.getDomain();
        super.visitHeartbeatReport(heartbeatReport);
    }

    public void visitMachine(Machine machine) {
        this.m_newGcs = new ArrayList();
        this.m_fullGcs = new ArrayList();
        this.m_loads = new ArrayList();
        super.visitMachine(machine);
        double newgc = this.computeDuration(this.m_newGcs);
        double fullgc = this.computeDuration(this.m_fullGcs);
        double load = this.computeAvg(this.m_loads);
        Domain current = this.m_report.findOrCreateDomain(this.m_domain);
        MachineState newGcState = current.findOrCreateMachineState("newGc");
        MachineState fullGcState = current.findOrCreateMachineState("fullGc");
        MachineState loadState = current.findOrCreateMachineState("load");
        this.updateMachineState(newGcState, newgc, newgc);
        this.updateMachineState(fullGcState, fullgc, fullgc);
        this.updateMachineState(loadState, load, this.findMax(this.m_loads));
    }

    public void visitPeriod(Period period) {
        super.visitPeriod(period);
        this.m_newGcs.add(period.findOrCreateExtension("GC").findOrCreateDetail("ParNewCount").getValue());
        this.m_fullGcs.add(period.findOrCreateExtension("GC").findOrCreateDetail("ConcurrentMarkSweepCount").getValue());
        this.m_loads.add(period.findOrCreateExtension("System").findOrCreateDetail("LoadAverage").getValue());
    }
}

