/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.service.AlertService;
import com.dianping.cat.consumer.storage.builder.StorageBuilderManager;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.home.dal.report.Alteration;
import com.dianping.cat.home.dal.report.AlterationDao;
import com.dianping.cat.home.dal.report.AlterationEntity;
import com.dianping.cat.home.storage.alert.entity.Storage;
import com.dianping.cat.home.storage.alert.entity.StorageAlertInfo;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.storage.Action;
import com.dianping.cat.report.page.storage.Context;
import com.dianping.cat.report.page.storage.Handler;
import com.dianping.cat.report.page.storage.JspViewer;
import com.dianping.cat.report.page.storage.Model;
import com.dianping.cat.report.page.storage.Payload;
import com.dianping.cat.report.page.storage.config.StorageGroupConfigManager;
import com.dianping.cat.report.page.storage.display.StorageAlertInfoBuilder;
import com.dianping.cat.report.page.storage.display.StorageSorter;
import com.dianping.cat.report.page.storage.task.StorageReportService;
import com.dianping.cat.report.page.storage.transform.HourlyLineChartVisitor;
import com.dianping.cat.report.page.storage.transform.PieChartVisitor;
import com.dianping.cat.report.page.storage.transform.StorageMergeHelper;
import com.dianping.cat.report.page.storage.transform.StorageOperationFilter;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private StorageReportService m_reportService;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject(type=ModelService.class, value={"storage"})
    private ModelService<StorageReport> m_service;
    @Inject
    private StorageMergeHelper m_mergeHelper;
    @Inject
    private StorageGroupConfigManager m_storageGroupConfigManager;
    @Inject
    private JsonBuilder m_jsonBuilder;
    @Inject
    private AlterationDao m_alterationDao;
    @Inject
    private AlertService m_alertService;
    @Inject
    private StorageAlertInfoBuilder m_alertInfoBuilder;
    @Inject
    private StorageBuilderManager m_storageBuilderManager;

    private Map<String, Map<String, List<String>>> buildAlertLinks(Map<String, StorageAlertInfo> alertInfos, String type) {
        LinkedHashMap<String, Map<String, List<String>>> links = new LinkedHashMap<String, Map<String, List<String>>>();
        String format = this.m_storageGroupConfigManager.queryLinkFormat(type);
        if (format != null) {
            for (Map.Entry<String, StorageAlertInfo> alertInfo : alertInfos.entrySet()) {
                String key = alertInfo.getKey();
                LinkedHashMap linkMap = (LinkedHashMap)links.get(key);
                if (linkMap == null) {
                    linkMap = new LinkedHashMap();
                    links.put(key, linkMap);
                }
                for (Map.Entry entry : alertInfo.getValue().getStorages().entrySet()) {
                    String id = (String)entry.getKey();
                    Storage storage = (Storage)entry.getValue();
                    ArrayList<String> ls = (ArrayList<String>)linkMap.get(id);
                    if (ls == null) {
                        ls = new ArrayList<String>();
                        linkMap.put(id, ls);
                    }
                    for (String ip : storage.getMachines().keySet()) {
                        String url = this.m_storageGroupConfigManager.buildUrl(format, id, ip);
                        if (url == null) continue;
                        ls.add(url);
                    }
                }
            }
        }
        return links;
    }

    private List<Alteration> buildAlterations(Date start, Date end, String type) {
        LinkedList<Alteration> results = new LinkedList<Alteration>();
        try {
            List alterations = this.m_alterationDao.findByTypeDruation(start, end, type, AlterationEntity.READSET_FULL);
            for (Alteration alteration : alterations) {
                results.add(alteration);
            }
        }
        catch (DalNotFoundException alterations) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return results;
    }

    private void buildDepartments(Payload payload, Model model, StorageReport storageReport) {
        Map departments = this.m_storageGroupConfigManager.queryStorageDepartments(SortHelper.sortDomain((Collection)storageReport.getIds()), payload.getType());
        model.setDepartments(departments);
    }

    private void buildLineCharts(Model model, Payload payload, StorageReport storageReport) {
        HourlyLineChartVisitor visitor = new HourlyLineChartVisitor(payload.getIpAddress(), payload.getProject(), storageReport.getOps(), storageReport.getStartTime());
        visitor.visitStorageReport(storageReport);
        Map lineCharts = visitor.getLineChart();
        model.setCountTrend(this.m_jsonBuilder.toJson(lineCharts.get("count")));
        model.setAvgTrend(this.m_jsonBuilder.toJson(lineCharts.get("avg")));
        model.setErrorTrend(this.m_jsonBuilder.toJson(lineCharts.get("error")));
        model.setLongTrend(this.m_jsonBuilder.toJson(lineCharts.get("long")));
    }

    private Pair<Boolean, Set<String>> buildOperations(Payload payload, Model model, Set<String> defaultValue) {
        String operations = payload.getOperations();
        HashSet<String> ops = new HashSet<String>();
        boolean filter = false;
        if (operations.length() > 0) {
            filter = true;
            String[] op = operations.split(";");
            for (int i = 0; i < op.length; ++i) {
                ops.add(op[i]);
            }
        } else {
            ops.addAll(defaultValue);
        }
        return new Pair((Object)filter, ops);
    }

    private String buildOperationStr(List<String> ops) {
        return StringUtils.join(ops, (String)";");
    }

    private void buildPieCharts(Model model, Payload payload, StorageReport report) {
        PieChartVisitor visitor = new PieChartVisitor();
        visitor.visitStorageReport(report);
        model.setDistributionChart(visitor.getPiechartJson());
    }

    private String buildReportId(Payload payload) {
        return payload.getId() + "-" + payload.getType();
    }

    private StorageReport filterReport(Payload payload, Model model, StorageReport storageReport) {
        if (storageReport != null) {
            Set allOps = storageReport.getOps();
            model.setOperations(allOps);
            Pair pair = this.buildOperations(payload, model, allOps);
            if (((Boolean)pair.getKey()).booleanValue()) {
                StorageOperationFilter filter = new StorageOperationFilter((Set)pair.getValue());
                filter.visitStorageReport(storageReport);
                storageReport = filter.getStorageReport();
            }
        }
        return storageReport;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="storage")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="storage")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.normalize(model, payload);
        StorageReport storageReport = null;
        StorageReport rawReport = null;
        switch (2.$SwitchMap$com$dianping$cat$report$page$storage$Action[payload.getAction().ordinal()]) {
            case 1: {
                storageReport = this.queryHourlyReport(payload);
                model.setOriginalReport(storageReport);
                rawReport = this.filterReport(payload, model, storageReport);
                storageReport = this.mergeReport(payload, rawReport);
                model.setReport(storageReport);
                this.buildDepartments(payload, model, storageReport);
                break;
            }
            case 2: {
                storageReport = this.queryHourlyReport(payload);
                rawReport = this.filterReport(payload, model, storageReport);
                if ("All".equals(payload.getIpAddress())) {
                    this.buildPieCharts(model, payload, rawReport);
                }
                storageReport = this.mergeReport(payload, rawReport);
                model.setReport(storageReport);
                this.buildLineCharts(model, payload, storageReport);
                this.buildDepartments(payload, model, storageReport);
                break;
            }
            case 3: {
                storageReport = this.queryHistoryReport(payload);
                model.setOriginalReport(storageReport);
                rawReport = this.filterReport(payload, model, storageReport);
                storageReport = this.mergeReport(payload, rawReport);
                model.setReport(storageReport);
                this.buildDepartments(payload, model, storageReport);
                break;
            }
            case 4: {
                int minuteCounts = payload.getMinuteCounts();
                long time = payload.getDate();
                long end = time + (long)model.getMinute() * 60000L;
                Date startDate = new Date(end - (long)(minuteCounts - 1) * 60000L);
                Date endDate = new Date(end);
                String type = payload.getType();
                List alerts = this.m_alertService.query(new Date(startDate.getTime() + 60000L), new Date(endDate.getTime() + 60000L), type);
                Map alertInfos = this.m_alertInfoBuilder.buildStorageAlertInfos(startDate, endDate, minuteCounts, type, alerts);
                alertInfos = this.sortAlertInfos(alertInfos);
                model.setLinks(this.buildAlertLinks(alertInfos, type));
                model.setAlertInfos(alertInfos);
                model.setReportStart(new Date(time));
                model.setReportEnd(new Date(time + 3600000L - 1L));
                model.setAlterations(this.buildAlterations(startDate, endDate, type));
            }
        }
        model.setPage((Page)ReportPage.STORAGE);
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    private StorageReport mergeReport(Payload payload, StorageReport storageReport) {
        storageReport = this.m_mergeHelper.mergeReport(storageReport, payload.getIpAddress(), "All");
        StorageSorter sorter = new StorageSorter(storageReport, payload.getSort());
        return sorter.getSortedReport();
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.STORAGE);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        if (payload.getAction() == Action.DASHBOARD) {
            Integer minute = this.parseQueryMinute(payload);
            int maxMinute = 60;
            ArrayList<Integer> minutes = new ArrayList<Integer>();
            if (payload.getPeriod().isCurrent()) {
                long current = payload.getCurrentTimeMillis() / 1000L / 60L;
                maxMinute = (int)(current % 60L);
            }
            for (int i = 0; i < 60; ++i) {
                minutes.add(i);
            }
            model.setMinute(minute.intValue());
            model.setMaxMinute(maxMinute);
            model.setMinutes(minutes);
        } else if (payload.getOperations() == null) {
            List defaultMethods = this.m_storageBuilderManager.getDefaultMethods(payload.getType());
            payload.setOperations(this.buildOperationStr(defaultMethods));
        }
    }

    private int parseQueryMinute(Payload payload) {
        int minute = 0;
        String min = payload.getMinute();
        if (StringUtils.isEmpty((String)min)) {
            long current = payload.getCurrentTimeMillis() / 1000L / 60L;
            minute = (int)(current % 60L);
        } else {
            minute = Integer.parseInt(min);
        }
        return minute;
    }

    public StorageReport queryHistoryReport(Payload payload) {
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        return (StorageReport)this.m_reportService.queryReport(this.buildReportId(payload), start, end);
    }

    private StorageReport queryHourlyReport(Payload payload) {
        ModelRequest request = new ModelRequest(this.buildReportId(payload), payload.getDate()).setProperty("ip", payload.getIpAddress());
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            StorageReport report = (StorageReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligable transaction service registered for " + request + "!");
    }

    public Map<String, StorageAlertInfo> sortAlertInfos(Map<String, StorageAlertInfo> alertInfos) {
        LinkedHashMap<String, StorageAlertInfo> results = new LinkedHashMap<String, StorageAlertInfo>();
        for (Map.Entry<String, StorageAlertInfo> entry : alertInfos.entrySet()) {
            StorageAlertInfo alertInfo = entry.getValue();
            ArrayList entries = new ArrayList(alertInfo.getStorages().entrySet());
            Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
            StorageAlertInfo result = this.m_alertInfoBuilder.makeAlertInfo(alertInfo.getId(), alertInfo.getStartTime());
            Map storages = result.getStorages();
            for (Map.Entry entry2 : entries) {
                storages.put(entry2.getKey(), entry2.getValue());
            }
            results.put(entry.getKey(), result);
        }
        return SortHelper.sortMap(results, (Comparator)new MinuteComparator());
    }
}

