/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.storage.entity.Link;
import com.dianping.cat.home.storage.entity.Storage;
import com.dianping.cat.home.storage.entity.StorageGroup;
import com.dianping.cat.home.storage.entity.StorageGroupConfig;
import com.dianping.cat.home.storage.transform.DefaultSaxParser;
import com.dianping.cat.report.page.storage.config.StorageGroupConfigManager;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.util.StringUtils;

@Named
public class StorageGroupConfigManager
implements Initializable {
    public static final String IP_FORMAT = "${ip}";
    public static final String ID_FORMAT = "${id}";
    public static final String DEFAULT = "Default";
    private static final String CONFIG_NAME = "storageGroup";
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private StorageGroupConfig m_config;

    public String buildUrl(String format, String id, String ip) {
        try {
            return format.replace(ID_FORMAT, URLEncoder.encode(id, "utf-8")).replace(IP_FORMAT, URLEncoder.encode(ip, "utf-8"));
        }
        catch (Exception e) {
            Cat.logError((String)("can't encode [id: " + id + "] [ip: " + ip + "]"), (Throwable)e);
            return null;
        }
    }

    public StorageGroupConfig getConfig() {
        return this.m_config;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new StorageGroupConfig();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public String queryLinkFormat(String type) {
        StorageGroup group = this.queryStorageGroup(type);
        Link link = group.getLink();
        if (link != null) {
            String url = link.getUrl();
            List pars = link.getPars();
            return url + "?" + StringUtils.join((Collection)pars, (String)"&");
        }
        return null;
    }

    public Map<String, Department> queryStorageDepartments(List<String> ids, String type) {
        LinkedHashMap<String, Department> departments = new LinkedHashMap<String, Department>();
        for (String id : ids) {
            String product;
            String department;
            Storage storage = (Storage)this.queryStorageGroup(type).getStorages().get(id);
            if (storage != null) {
                department = storage.getDepartment();
                product = storage.getProductline();
            } else {
                department = DEFAULT;
                product = DEFAULT;
            }
            Department depart = (Department)departments.get(department);
            if (depart == null) {
                depart = new Department(department);
                departments.put(department, depart);
            }
            depart.findOrCreateProductline(product).addStorage(id);
        }
        return departments;
    }

    public StorageGroup queryStorageGroup(String type) {
        StorageGroup group = (StorageGroup)this.m_config.getStorageGroups().get(type);
        if (group != null) {
            return group;
        }
        return new StorageGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        StorageGroupConfigManager storageGroupConfigManager = this;
        synchronized (storageGroupConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
                return true;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
    }
}

