/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.transform;

import com.dianping.cat.consumer.storage.model.entity.Domain;
import com.dianping.cat.consumer.storage.model.entity.Operation;
import com.dianping.cat.consumer.storage.model.entity.Segment;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.consumer.storage.model.transform.BaseVisitor;

public class AllMachineMerger
extends BaseVisitor {
    private StorageReport m_storageReport;
    private String m_currentDomain;
    private String m_currentOperation;

    public StorageReport getStorageReport() {
        return this.m_storageReport;
    }

    public void visitDomain(Domain domain) {
        this.m_currentDomain = domain.getId();
        super.visitDomain(domain);
    }

    public void visitOperation(Operation operation) {
        this.m_currentOperation = operation.getId();
        Operation to = this.m_storageReport.findOrCreateMachine("All").findOrCreateDomain(this.m_currentDomain).findOrCreateOperation(this.m_currentOperation);
        to.setCount(to.getCount() + operation.getCount());
        to.setLongCount(to.getLongCount() + operation.getLongCount());
        to.setError(to.getError() + operation.getError());
        to.setSum(to.getSum() + operation.getSum());
        to.setAvg(to.getCount() > 0L ? to.getSum() / (double)to.getCount() : 0.0);
        super.visitOperation(operation);
    }

    public void visitSegment(Segment segment) {
        Segment to = this.m_storageReport.findOrCreateMachine("All").findOrCreateDomain(this.m_currentDomain).findOrCreateOperation(this.m_currentOperation).findOrCreateSegment(segment.getId());
        to.setCount(to.getCount() + segment.getCount());
        to.setLongCount(to.getLongCount() + segment.getLongCount());
        to.setError(to.getError() + segment.getError());
        to.setSum(to.getSum() + segment.getSum());
        to.setAvg(to.getCount() > 0L ? to.getSum() / (double)to.getCount() : 0.0);
    }

    public void visitStorageReport(StorageReport storageReport) {
        this.m_storageReport = new StorageReport(storageReport.getId());
        this.m_storageReport.setName(storageReport.getName()).setType(storageReport.getType()).setStartTime(storageReport.getStartTime()).setEndTime(storageReport.getEndTime());
        this.m_storageReport.getIds().addAll(storageReport.getIds());
        this.m_storageReport.getIps().addAll(storageReport.getIps());
        this.m_storageReport.getOps().addAll(storageReport.getOps());
        super.visitStorageReport(storageReport);
    }
}

